/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.util.LangUtil;
import net.vit.jurassicreborn.common.util.api.DinosaurItem;
import net.vit.jurassicreborn.common.util.api.SequencableItem;

public class SoftTissueItem
extends Item
implements SequencableItem,
DinosaurItem {
    protected final Dinosaur dino;

    public SoftTissueItem(Item.Properties pProperties, Dinosaur dino) {
        super(pProperties);
        this.dino = dino;
    }

    public Component m_7626_(ItemStack pStack) {
        return LangUtil.replaceWithDinoName(this.dino, "item.JurassicReborn.soft_tissue");
    }

    @Override
    public Dinosaur getDinosaur(ItemStack stack) {
        if (stack.m_41720_() == this) {
            return this.dino;
        }
        Item item = stack.m_41720_();
        if (item instanceof SoftTissueItem) {
            SoftTissueItem i = (SoftTissueItem)item;
            return i.getDinosaur(stack);
        }
        item = stack.m_41720_();
        if (item instanceof DinosaurItem) {
            DinosaurItem i = (DinosaurItem)item;
            return i.getDinosaur(stack);
        }
        return Dinosaur.EMPTY;
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        CompoundTag nbt = new CompoundTag();
        DinoDNA dna = new DinoDNA(this.getDinosaur(inputItem), -1, "");
        dna.writeToNBT(nbt);
        ItemStack output = new ItemStack((ItemLike)ModItems.STORAGE_DISC.get());
        output.m_41751_(nbt);
        StorageDiscItem.applyCustomModelData(output);
        list.add(Pair.of((Object)Float.valueOf(100.0f), (Object)output));
        return list;
    }

    @Override
    public boolean isSequencable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getSequenceOutput(ItemStack stack, Random random) {
        CompoundTag tag = stack.m_41783_();
        DinoDNA dna = tag != null ? DinoDNA.readFromNBT(tag) : null;
        int quality = dna != null ? dna.getDNAQuality() : Math.abs(SequencableItem.randomQuality(random) / 2);
        String genes = dna != null ? dna.getGenetics() : GeneticsHelper.randomGenetics(random);
        ItemStack out = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
        new DinoDNA(this.getDinosaur(stack), quality, genes).writeToNBT(out.m_41784_());
        StorageDiscItem.applyCustomModelData(out);
        return out;
    }

    private void initDnaCompound(ItemStack stack, Random random, CompoundTag nbt) {
        int quality = Math.abs(SequencableItem.randomQuality(random) / 2);
        DinoDNA dna = new DinoDNA(this.getDinosaur(stack), quality, GeneticsHelper.randomGenetics(random));
        dna.writeToNBT(nbt);
    }
}

