/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNACombinatorHybridizer.DNACombinatorHybridizerMenu;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASequencer.DNASequencerMenu;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASynthesizer.DNASynthesizerMenu;
import net.vit.jurassicreborn.common.blocks.entities.bugcrate.BugCrateMenu;
import net.vit.jurassicreborn.common.blocks.entities.cleaner.CleanerMenu;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorMenu;
import net.vit.jurassicreborn.common.blocks.entities.grinder.FossilGrinderMenu;
import net.vit.jurassicreborn.common.blocks.entities.incubator.IncubatorMenu;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonAssemblerMenu;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonAssemblyCategory;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonInput;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.EntityUtils.Hybrid;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.jei.bugcrate.BugCrateCategory;
import net.vit.jurassicreborn.common.jei.bugcrate.BugCrateRecipeExtension;
import net.vit.jurassicreborn.common.jei.cleaningstation.CleanableInput;
import net.vit.jurassicreborn.common.jei.cleaningstation.CleaningStationCategory;
import net.vit.jurassicreborn.common.jei.cleaningstation.CleaningStationRecipeExtension;
import net.vit.jurassicreborn.common.jei.cultivate.CultivateInput;
import net.vit.jurassicreborn.common.jei.cultivate.CultivatorRecipeCategory;
import net.vit.jurassicreborn.common.jei.cultivate.CultivatorRecipeExtension;
import net.vit.jurassicreborn.common.jei.dnacombinator.DNACombinatorCategory;
import net.vit.jurassicreborn.common.jei.dnacombinator.DNACombinatorRecipeExtension;
import net.vit.jurassicreborn.common.jei.dnaextractor.DNAExtractorCategory;
import net.vit.jurassicreborn.common.jei.dnaextractor.DNAExtractorRecipeExtension;
import net.vit.jurassicreborn.common.jei.dnahybridizer.DNAHybridizerCategory;
import net.vit.jurassicreborn.common.jei.dnahybridizer.DNAHybridizerRecipeExtension;
import net.vit.jurassicreborn.common.jei.dnasequencer.DNASequencerCategory;
import net.vit.jurassicreborn.common.jei.dnasequencer.DNASequencerRecipeExtension;
import net.vit.jurassicreborn.common.jei.dnasequencer.SequencerInput;
import net.vit.jurassicreborn.common.jei.dnasynthesizer.DNASynthesizerCategory;
import net.vit.jurassicreborn.common.jei.dnasynthesizer.DNASynthesizerRecipeExtension;
import net.vit.jurassicreborn.common.jei.dnasynthesizer.SynthesizerInput;
import net.vit.jurassicreborn.common.jei.embryonic.EmbryoInput;
import net.vit.jurassicreborn.common.jei.embryonic.EmbryonicRecipeCategory;
import net.vit.jurassicreborn.common.jei.embryonic.EmbryonicRecipeExtension;
import net.vit.jurassicreborn.common.jei.embryoniccalcification.CalcificationInput;
import net.vit.jurassicreborn.common.jei.embryoniccalcification.CalcificationRecipeCategory;
import net.vit.jurassicreborn.common.jei.embryoniccalcification.CalcificationRecipeExtension;
import net.vit.jurassicreborn.common.jei.fossilgrinder.FossilGrinderCategory;
import net.vit.jurassicreborn.common.jei.fossilgrinder.FossilGrinderRecipeExtension;
import net.vit.jurassicreborn.common.jei.fossilgrinder.GrinderInput;
import net.vit.jurassicreborn.common.jei.incubator.IncubatorInput;
import net.vit.jurassicreborn.common.jei.incubator.IncubatorRecipeCategory;
import net.vit.jurassicreborn.common.jei.incubator.IncubatorRecipeExtension;
import net.vit.jurassicreborn.common.jei.skeletonassembly.SkeletonAssemblyRecipeExtension;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.util.BreedableBug;
import net.vit.jurassicreborn.common.util.api.CleanableItem;
import net.vit.jurassicreborn.common.util.api.GrindableItem;
import net.vit.jurassicreborn.common.util.api.SequencableItem;

@JeiPlugin
public class JRJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("jurassicreborn", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper gui = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new SkeletonAssemblyCategory(gui), new CleaningStationCategory(gui), new FossilGrinderCategory(gui), new DNASequencerCategory(gui), new DNASynthesizerCategory(gui), new DNAExtractorCategory(gui), new EmbryonicRecipeCategory(gui), new CalcificationRecipeCategory(gui), new CultivatorRecipeCategory(gui), new IncubatorRecipeCategory(gui), new DNACombinatorCategory(gui), new DNAHybridizerCategory(gui), new BugCrateCategory(gui)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SKELETON_ASSEMBLY.get()), new RecipeType[]{SkeletonAssemblyCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CLEANING_STATION.get()), new RecipeType[]{CleaningStationCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FOSSIL_GRINDER.get()), new RecipeType[]{FossilGrinderCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_SEQUENCER.get()), new RecipeType[]{DNASequencerCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_SYNTHESIZER.get()), new RecipeType[]{DNASynthesizerCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_EXTRACTOR.get()), new RecipeType[]{DNAExtractorCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EMBRYONIC_MACHINE.get()), new RecipeType[]{EmbryonicRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EMBRYO_CALCIFICATION_MACHINE.get()), new RecipeType[]{CalcificationRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CULTIVATE_BOTTOM.get()), new RecipeType[]{CultivatorRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()), new RecipeType[]{IncubatorRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_COMBINER_HYBRIDIZER.get()), new RecipeType[]{DNACombinatorCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_COMBINER_HYBRIDIZER.get()), new RecipeType[]{DNAHybridizerCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BUG_CRATE.get()), new RecipeType[]{BugCrateCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<SkeletonAssemblyRecipeExtension> recipes = new ArrayList<SkeletonAssemblyRecipeExtension>();
        for (Dinosaur dino : Dinosaur.DINOS) {
            if (dino.getRecipe() == null) continue;
            if (ModItems.BONES.containsKey(dino)) {
                recipes.add(new SkeletonAssemblyRecipeExtension(new SkeletonInput(dino, false)));
            }
            if (!ModItems.FRESH_BONES.containsKey(dino)) continue;
            recipes.add(new SkeletonAssemblyRecipeExtension(new SkeletonInput(dino, true)));
        }
        registration.addRecipes(SkeletonAssemblyCategory.TYPE, recipes);
        ArrayList cleaning = new ArrayList();
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            CleanableItem clean = CleanableItem.getCleanableItem(stack);
            if (clean != null && clean.isCleanable(stack)) {
                cleaning.add(new CleaningStationRecipeExtension(new CleanableInput(stack)));
            }
        });
        registration.addRecipes(CleaningStationCategory.TYPE, cleaning);
        ArrayList grinding = new ArrayList();
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            GrindableItem grind = GrindableItem.getGrindableItem(stack);
            if (grind != null && grind.isGrindable(stack)) {
                grinding.add(new FossilGrinderRecipeExtension(new GrinderInput(stack)));
            }
        });
        registration.addRecipes(FossilGrinderCategory.TYPE, grinding);
        ArrayList sequencing = new ArrayList();
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            SequencableItem seq = SequencableItem.getSequencableItem(stack);
            if (seq != null && seq.isSequencable(stack)) {
                sequencing.add(new DNASequencerRecipeExtension(new SequencerInput(stack)));
            }
        });
        registration.addRecipes(DNASequencerCategory.TYPE, sequencing);
        ArrayList<DNASynthesizerRecipeExtension> synthesize = new ArrayList<DNASynthesizerRecipeExtension>();
        StorageDiscItem discItem = (StorageDiscItem)ModItems.STORAGE_DISC.get();
        for (ItemStack itemStack : discItem.getJEIRecipeTypes()) {
            if (!discItem.isSynthesizable(itemStack)) continue;
            synthesize.add(new DNASynthesizerRecipeExtension(new SynthesizerInput(itemStack)));
        }
        registration.addRecipes(DNASynthesizerCategory.TYPE, synthesize);
        registration.addRecipes(DNAExtractorCategory.TYPE, DNAExtractorRecipeExtension.createRecipes());
        ArrayList<EmbryonicRecipeExtension> embryonic = new ArrayList<EmbryonicRecipeExtension>();
        for (Dinosaur dinosaur : Dinosaur.DINOS) {
            EmbryoInput.DinosaurInput dinosaurInput = new EmbryoInput.DinosaurInput(dinosaur);
            if (!dinosaurInput.isValid()) continue;
            embryonic.add(new EmbryonicRecipeExtension(dinosaurInput));
        }
        for (Plant plant : PlantHandler.getPrehistoricPlantsAndTrees()) {
            EmbryoInput.PlantInput plantInput = new EmbryoInput.PlantInput(plant);
            if (!plantInput.isValid()) continue;
            embryonic.add(new EmbryonicRecipeExtension(plantInput));
        }
        registration.addRecipes(EmbryonicRecipeCategory.TYPE, embryonic);
        ArrayList<CalcificationRecipeExtension> arrayList = new ArrayList<CalcificationRecipeExtension>();
        for (Dinosaur dinosaur : Dinosaur.DINOS) {
            if (dinosaur.getBirthType() != Dinosaur.BirthType.EGG_LAYING || dinosaur.isMarineCreature() && dinosaur != DinosaurHandler.CALYMENE && dinosaur != DinosaurHandler.BEELZEBUFO || !ModItems.dinoEggs.containsKey(dinosaur)) continue;
            arrayList.add(new CalcificationRecipeExtension(new CalcificationInput(dinosaur)));
        }
        registration.addRecipes(CalcificationRecipeCategory.TYPE, arrayList);
        ArrayList<CultivatorRecipeExtension> arrayList2 = new ArrayList<CultivatorRecipeExtension>();
        for (Dinosaur dinosaur : Dinosaur.DINOS) {
            if (!ModItems.SYRINGES.containsKey(dinosaur) || !dinosaur.isMarineCreature() && !dinosaur.isMammal()) continue;
            arrayList2.add(new CultivatorRecipeExtension(new CultivateInput(dinosaur)));
        }
        registration.addRecipes(CultivatorRecipeCategory.TYPE, arrayList2);
        ArrayList<IncubatorRecipeExtension> arrayList3 = new ArrayList<IncubatorRecipeExtension>();
        for (Dinosaur dinosaur : Dinosaur.DINOS) {
            if (!ModItems.dinoEggs.containsKey(dinosaur)) continue;
            arrayList3.add(new IncubatorRecipeExtension(new IncubatorInput(dinosaur)));
        }
        registration.addRecipes(IncubatorRecipeCategory.TYPE, arrayList3);
        ArrayList<DNACombinatorRecipeExtension> arrayList4 = new ArrayList<DNACombinatorRecipeExtension>();
        for (ItemStack itemStack : ((StorageDiscItem)ModItems.STORAGE_DISC.get()).getJEIRecipeTypes()) {
            arrayList4.add(new DNACombinatorRecipeExtension(itemStack));
        }
        registration.addRecipes(DNACombinatorCategory.TYPE, arrayList4);
        ArrayList<DNAHybridizerRecipeExtension> arrayList5 = new ArrayList<DNAHybridizerRecipeExtension>();
        for (Dinosaur dino : Dinosaur.DINOS) {
            if (!(dino instanceof Hybrid)) continue;
            arrayList5.add(new DNAHybridizerRecipeExtension(dino));
        }
        registration.addRecipes(DNAHybridizerCategory.TYPE, arrayList5);
        ArrayList arrayList6 = new ArrayList();
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (BreedableBug.isBug(stack)) {
                bugs.add(new BugCrateRecipeExtension(stack));
            }
        });
        registration.addRecipes(BugCrateCategory.TYPE, arrayList6);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(SkeletonAssemblerMenu.class, SkeletonAssemblyCategory.TYPE, 1, 25, 26, 36);
        registration.addRecipeTransferHandler(CleanerMenu.class, CleaningStationCategory.TYPE, 0, 2, 2, 36);
        registration.addRecipeTransferHandler(FossilGrinderMenu.class, FossilGrinderCategory.TYPE, 0, 6, 12, 36);
        registration.addRecipeTransferHandler(DNASequencerMenu.class, DNASequencerCategory.TYPE, 0, 6, 9, 36);
        registration.addRecipeTransferHandler(DNASynthesizerMenu.class, DNASynthesizerCategory.TYPE, 0, 3, 7, 36);
        registration.addRecipeTransferHandler(CultivatorMenu.class, CultivatorRecipeCategory.TYPE, 0, 4, 4, 36);
        registration.addRecipeTransferHandler(IncubatorMenu.class, IncubatorRecipeCategory.TYPE, 0, 6, 6, 36);
        registration.addRecipeTransferHandler(DNACombinatorHybridizerMenu.class, DNACombinatorCategory.TYPE, 8, 2, 12, 36);
        registration.addRecipeTransferHandler(DNACombinatorHybridizerMenu.class, DNAHybridizerCategory.TYPE, 0, 8, 12, 36);
        registration.addRecipeTransferHandler(BugCrateMenu.class, BugCrateCategory.TYPE, 0, 6, 9, 36);
    }
}

