/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.jei.embryonic;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.DNAItem;
import net.vit.jurassicreborn.common.items.genetics.SyringeItem;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;

public interface EmbryoInput {
    public boolean isValid();

    public int getMetadata();

    public CompoundTag getTag();

    public Item getInputItem();

    public Item getOutputItem();

    public Item getPetriDishItem();

    public static class PlantInput
    implements EmbryoInput {
        public final Plant plant;

        public PlantInput(Plant plant) {
            this.plant = plant;
        }

        @Override
        public boolean isValid() {
            return this.plant.shouldRegister();
        }

        @Override
        public int getMetadata() {
            return PlantHandler.getPlants().indexOf(this.plant);
        }

        @Override
        public CompoundTag getTag() {
            PlantDNA dna = new PlantDNA(PlantHandler.getPlantId(this.plant), 100);
            CompoundTag tag = new CompoundTag();
            dna.writeToNBT(tag);
            return tag;
        }

        @Override
        public Item getInputItem() {
            RegistryObject<Item> regObj = ModItems.PLANT_DNAS.get(this.plant);
            return regObj != null ? (Item)regObj.get() : Items.f_41852_;
        }

        @Override
        public Item getOutputItem() {
            return (Item)ModItems.PLANT_CALLUS.get();
        }

        @Override
        public Item getPetriDishItem() {
            return (Item)ModItems.PLANT_CELLS_PETRI_DISH.get();
        }
    }

    public static class DinosaurInput
    implements EmbryoInput {
        public final Dinosaur dinosaur;

        public DinosaurInput(Dinosaur dinosaur) {
            this.dinosaur = dinosaur;
        }

        @Override
        public boolean isValid() {
            return this.dinosaur.shouldRegister();
        }

        @Override
        public int getMetadata() {
            return DinosaurHandler.getId(this.dinosaur);
        }

        @Override
        public CompoundTag getTag() {
            DinoDNA dna = new DinoDNA(this.dinosaur, 100, GeneticsHelper.randomGenetics(new Random()));
            CompoundTag tag = new CompoundTag();
            dna.writeToNBT(tag);
            return tag;
        }

        @Override
        public Item getInputItem() {
            RegistryObject<DNAItem> regObj = ModItems.DINOSAUR_DNA.get(this.dinosaur);
            return regObj != null ? (Item)regObj.get() : Items.f_41852_;
        }

        @Override
        public Item getOutputItem() {
            RegistryObject<SyringeItem> regObj = ModItems.SYRINGES.get(this.dinosaur);
            return regObj != null ? (Item)regObj.get() : Items.f_41852_;
        }

        @Override
        public Item getPetriDishItem() {
            return (Item)ModItems.PETRI_DISH.get();
        }
    }
}

