/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.vit.jurassicreborn.common.CommonRegistries;
import net.vit.jurassicreborn.common.blocks.GypsumStoneBlock;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.ancientplants.GracilariaBlock;
import net.vit.jurassicreborn.common.blocks.ancientplants.HeliconiaBlock;
import net.vit.jurassicreborn.common.blocks.ancientplants.moss.PeatBlock;
import net.vit.jurassicreborn.common.blocks.fossil.FaunaFossil;
import net.vit.jurassicreborn.common.blocks.fossil.FloraFossil;
import net.vit.jurassicreborn.common.plants.WestIndianLilacBlock;
import net.vit.jurassicreborn.common.worldgen.JRTreeFeatures;
import net.vit.jurassicreborn.common.worldgen.ModConfiguredFeatures;
import net.vit.jurassicreborn.common.worldgen.ModFeatures;
import net.vit.jurassicreborn.common.worldgen.ModPlacements;
import net.vit.jurassicreborn.common.worldgen.tree.petrified.PetrifiedTreeConfig;

public class ConfiguredFeatureRegistries {
    private static final List<FossilOreDefinition> DINO_FOSSILS = List.of(new FossilOreDefinition("achillobator", (Supplier<? extends Block>)ModBlocks.ACHILLOBATOR_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("alligator_gar", (Supplier<? extends Block>)ModBlocks.ALLIGATOR_GAR_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("allosaurus", (Supplier<? extends Block>)ModBlocks.ALLOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("alvarezsaurus", (Supplier<? extends Block>)ModBlocks.ALVAREZSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("ankylosaurus", (Supplier<? extends Block>)ModBlocks.ANKYLOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("apatosaurus", (Supplier<? extends Block>)ModBlocks.APATOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("arsinoitherium", (Supplier<? extends Block>)ModBlocks.ARSINOITHERIUM_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("asteroceras", (Supplier<? extends Block>)ModBlocks.ASTEROCERAS_FOSSIL, 6, 1, 4, 16, true, true), new FossilOreDefinition("baryonyx", (Supplier<? extends Block>)ModBlocks.BARYONYX_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("beelzebufo", (Supplier<? extends Block>)ModBlocks.BEELZEBUFO_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("brachiosaurus", (Supplier<? extends Block>)ModBlocks.BRACHIOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("calymene", (Supplier<? extends Block>)ModBlocks.CALYMENE_FOSSIL, 6, 1, -50, -36, false, true), new FossilOreDefinition("camarasaurus", (Supplier<? extends Block>)ModBlocks.CAMARASAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("cameroceras", (Supplier<? extends Block>)ModBlocks.CAMEROCERAS_FOSSIL, 6, 1, -50, -40, false, true), new FossilOreDefinition("carcharodontosaurus", (Supplier<? extends Block>)ModBlocks.CARCHARODONTOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("carnotaurus", (Supplier<? extends Block>)ModBlocks.CARNOTAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("cearadactylus", (Supplier<? extends Block>)ModBlocks.CEARADACTYLUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("ceratosaurus", (Supplier<? extends Block>)ModBlocks.CERATOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("chasmosaurus", (Supplier<? extends Block>)ModBlocks.CHASMOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("chilesaurus", (Supplier<? extends Block>)ModBlocks.CHILESAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("coelacanth", (Supplier<? extends Block>)ModBlocks.COELACANTH_FOSSIL, 6, 1, -36, 72, true, true), new FossilOreDefinition("coelurus", (Supplier<? extends Block>)ModBlocks.COELURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("compsognathus", (Supplier<? extends Block>)ModBlocks.COMPSOGNATHUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("corythosaurus", (Supplier<? extends Block>)ModBlocks.CORYTHOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("crassigyrinus", (Supplier<? extends Block>)ModBlocks.CRASSIGYRINUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("deinosuchus", (Supplier<? extends Block>)ModBlocks.DEINOSUCHUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("deinotherium", (Supplier<? extends Block>)ModBlocks.DEINOTHERIUM_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("dilophosaurus", (Supplier<? extends Block>)ModBlocks.DILOPHOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("dimetrodon", (Supplier<? extends Block>)ModBlocks.DIMETRODON_FOSSIL, 6, 1, -6, 4, false, true), new FossilOreDefinition("dimorphodon", (Supplier<? extends Block>)ModBlocks.DIMORPHODON_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("diplocaulus", (Supplier<? extends Block>)ModBlocks.DIPLOCAULUS_FOSSIL, 6, 1, -6, 4, false, true), new FossilOreDefinition("diplodocus", (Supplier<? extends Block>)ModBlocks.DIPLODOCUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("dodo", (Supplier<? extends Block>)ModBlocks.DODO_FOSSIL, 6, 1, 58, 72, true, true), new FossilOreDefinition("dreadnoughtus", (Supplier<? extends Block>)ModBlocks.DREADNOUGHTUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("dunkleosteus", (Supplier<? extends Block>)ModBlocks.DUNKLEOSTEUS_FOSSIL, 6, 1, -36, -20, false, true), new FossilOreDefinition("edmontosaurus", (Supplier<? extends Block>)ModBlocks.EDMONTOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("elasmotherium", (Supplier<? extends Block>)ModBlocks.ELASMOTHERIUM_FOSSIL, 6, 1, 58, 72, true, true), new FossilOreDefinition("endoceras", (Supplier<? extends Block>)ModBlocks.ENDOCERAS_FOSSIL, 6, 1, -50, -40, false, true), new FossilOreDefinition("gallimimus", (Supplier<? extends Block>)ModBlocks.GALLIMIMUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("giganotosaurus", (Supplier<? extends Block>)ModBlocks.GIGANOTOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("guanlong", (Supplier<? extends Block>)ModBlocks.GUANLONG_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("herrerasaurus", (Supplier<? extends Block>)ModBlocks.HERRERASAURUS_FOSSIL, 6, 1, 4, 16, true, true), new FossilOreDefinition("hyaenodon", (Supplier<? extends Block>)ModBlocks.HYAENODON_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("hypsilophodon", (Supplier<? extends Block>)ModBlocks.HYPSILOPHODON_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("kairuku", (Supplier<? extends Block>)ModBlocks.KAIRUKU_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("lambeosaurus", (Supplier<? extends Block>)ModBlocks.LAMBEOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("leaellynasaura", (Supplier<? extends Block>)ModBlocks.LEAELLYNASAURA_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("leptictidium", (Supplier<? extends Block>)ModBlocks.LEPTICTIDIUM_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("livyatan", (Supplier<? extends Block>)ModBlocks.LIVYATAN_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("ludodactylus", (Supplier<? extends Block>)ModBlocks.LUDODACTYLUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("maiasaura", (Supplier<? extends Block>)ModBlocks.MAIASAURA_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("majungasaurus", (Supplier<? extends Block>)ModBlocks.MAJUNGASAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("mamenchisaurus", (Supplier<? extends Block>)ModBlocks.MAMENCHISAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("mammoth", (Supplier<? extends Block>)ModBlocks.MAMMOTH_FOSSIL, 6, 1, 58, 72, true, true), new FossilOreDefinition("mawsonia", (Supplier<? extends Block>)ModBlocks.MAWSONIA_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("megalodon", (Supplier<? extends Block>)ModBlocks.MEGALODON_FOSSIL, 6, 1, 58, 72, true, true), new FossilOreDefinition("megapiranha", (Supplier<? extends Block>)ModBlocks.MEGAPIRANHA_FOSSIL, 6, 1, 58, 72, true, true), new FossilOreDefinition("megatherium", (Supplier<? extends Block>)ModBlocks.MEGATHERIUM_FOSSIL, 6, 1, 58, 72, true, true), new FossilOreDefinition("metriacanthosaurus", (Supplier<? extends Block>)ModBlocks.METRIACANTHOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("microceratus", (Supplier<? extends Block>)ModBlocks.MICROCERATUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("microraptor", (Supplier<? extends Block>)ModBlocks.MICRORAPTOR_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("moganopterus", (Supplier<? extends Block>)ModBlocks.MOGANOPTERUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("mosasaurus", (Supplier<? extends Block>)ModBlocks.MOSASAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("mussaurus", (Supplier<? extends Block>)ModBlocks.MUSSAURUS_FOSSIL, 6, 1, 4, 16, true, true), new FossilOreDefinition("nigersaurus", (Supplier<? extends Block>)ModBlocks.NIGERSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("ornithomimus", (Supplier<? extends Block>)ModBlocks.ORNITHOMIMUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("orthoceras", (Supplier<? extends Block>)ModBlocks.ORTHOCERAS_FOSSIL, 6, 1, -50, -40, false, true), new FossilOreDefinition("othnielia", (Supplier<? extends Block>)ModBlocks.OTHNIELIA_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("oviraptor", (Supplier<? extends Block>)ModBlocks.OVIRAPTOR_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("pachycephalosaurus", (Supplier<? extends Block>)ModBlocks.PACHYCEPHALOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("paraceratherium", (Supplier<? extends Block>)ModBlocks.PARACERATHERIUM_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("parapuzosia", (Supplier<? extends Block>)ModBlocks.PARAPUZOSIA_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("parasaurolophus", (Supplier<? extends Block>)ModBlocks.PARASAUROLOPHUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("patagotitan", (Supplier<? extends Block>)ModBlocks.PATAGOTITAN_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("perisphinctes", (Supplier<? extends Block>)ModBlocks.PERISPHINCTES_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("postosuchus", (Supplier<? extends Block>)ModBlocks.POSTOSUCHUS_FOSSIL, 6, 1, 4, 16, true, true), new FossilOreDefinition("proceratosaurus", (Supplier<? extends Block>)ModBlocks.PROCERATOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("protoceratops", (Supplier<? extends Block>)ModBlocks.PROTOCERATOPS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("pteranodon", (Supplier<? extends Block>)ModBlocks.PTERANODON_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("quetzal", (Supplier<? extends Block>)ModBlocks.QUETZAL_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("rugops", (Supplier<? extends Block>)ModBlocks.RUGOPS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("segisaurus", (Supplier<? extends Block>)ModBlocks.SEGISAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("sinoceratops", (Supplier<? extends Block>)ModBlocks.SINOCERATOPS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("smilodon", (Supplier<? extends Block>)ModBlocks.SMILODON_FOSSIL, 6, 1, 48, 64, true, true), new FossilOreDefinition("spinosaurus", (Supplier<? extends Block>)ModBlocks.SPINOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("stegosaurus", (Supplier<? extends Block>)ModBlocks.STEGOSAURUS_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("styracosaurus", (Supplier<? extends Block>)ModBlocks.STYRACOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("suchomimus", (Supplier<? extends Block>)ModBlocks.SUCHOMIMUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("therizinosaurus", (Supplier<? extends Block>)ModBlocks.THERIZINOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("titanis", (Supplier<? extends Block>)ModBlocks.TITANIS_FOSSIL, 6, 1, 48, 58, true, true), new FossilOreDefinition("titanites", (Supplier<? extends Block>)ModBlocks.TITANITES_FOSSIL, 6, 1, 16, 30, true, true), new FossilOreDefinition("triceratops", (Supplier<? extends Block>)ModBlocks.TRICERATOPS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("troodon", (Supplier<? extends Block>)ModBlocks.TROODON_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("tropeognathus", (Supplier<? extends Block>)ModBlocks.TROPEOGNATHUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("tylosaurus", (Supplier<? extends Block>)ModBlocks.TYLOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("tyrannosaurus", (Supplier<? extends Block>)ModBlocks.TYRANNOSAURUS_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("vectipelta", (Supplier<? extends Block>)ModBlocks.VECTIPELTA_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("velociraptor", (Supplier<? extends Block>)ModBlocks.VELOCIRAPTOR_FOSSIL, 6, 1, 30, 48, true, true), new FossilOreDefinition("zhenyuanopterus", (Supplier<? extends Block>)ModBlocks.ZHENYUANOPTERUS_FOSSIL, 6, 1, 30, 48, true, true));

    public static void init() {
        JRTreeFeatures.AraucariaTree = FeatureUtils.m_206488_((String)"araucaria_tree", (Feature)((Feature)ModFeatures.AraucariaTreePre.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        JRTreeFeatures.GinkgoTree = FeatureUtils.m_206488_((String)"ginkgo_tree", (Feature)((Feature)ModFeatures.GinkgoTreePre.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        JRTreeFeatures.CalamitesTreeFeature = FeatureUtils.m_206488_((String)"calamites_tree", (Feature)((Feature)ModFeatures.CalamitesTreePre.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        JRTreeFeatures.PhoenixTreeFeature = FeatureUtils.m_206488_((String)"phoenix_tree", (Feature)((Feature)ModFeatures.PhoenixTreePre.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        JRTreeFeatures.PsaroniusTree = FeatureUtils.m_206488_((String)"psaronius_tree", (Feature)((Feature)ModFeatures.PsaroniusTreePre.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        JRTreeFeatures.MagnoliaTreeFeature = FeatureUtils.m_206488_((String)"magnolia_tree", (Feature)((Feature)ModFeatures.MagnoliaTreePre.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        CommonRegistries.ORE_FAUNA_FOSSIL_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((FaunaFossil)ModBlocks.FAUNA_FOSSIL.get()).m_49966_()));
        CommonRegistries.ORE_AMBER_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)ModBlocks.AMBER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)ModBlocks.DEEPSLATE_AMBER_ORE.get()).m_49966_()));
        CommonRegistries.ORE_ICE_SHARD_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)ModBlocks.AMBER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)ModBlocks.DEEPSLATE_AMBER_ORE.get()).m_49966_()));
        CommonRegistries.ORE_FLORA_FOSSIL_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((FloraFossil)ModBlocks.FLORA_FOSSIL.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((FloraFossil)ModBlocks.DEEPSLATE_FLORA_FOSSIL.get()).m_49966_()));
        ModConfiguredFeatures.CONFIGURED_FLORA_FOSSIL = FeatureUtils.m_206488_((String)"jurassicreborn:flora_fossil_configured", (Feature)((Feature)ModFeatures.FLORA_FOSSIL_ORE.get()), (FeatureConfiguration)new OreConfiguration(CommonRegistries.ORE_FLORA_FOSSIL_LIST, 17));
        ModPlacements.FLORA_FOSSIL_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:placement_flora_fossil", ModConfiguredFeatures.CONFIGURED_FLORA_FOSSIL, ConfiguredFeatureRegistries.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModConfiguredFeatures.CONFIGURED_FAUNA_FOSSIL = FeatureUtils.m_206488_((String)"jurassicreborn:fauna_fossil_configured", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CommonRegistries.ORE_FAUNA_FOSSIL_LIST, 3));
        ModPlacements.FAUNA_FOSSIL_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:placement_fauna_fossil", ModConfiguredFeatures.CONFIGURED_FAUNA_FOSSIL, ConfiguredFeatureRegistries.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModConfiguredFeatures.CONFIGURED_AMBER_ORE = FeatureUtils.m_206488_((String)"jurassicreborn:amber_ore_configured", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CommonRegistries.ORE_AMBER_LIST, 3));
        ModConfiguredFeatures.CONFIGURED_ICE_SHARD_ORE = FeatureUtils.m_206488_((String)"jurassicreborn:ice_shard_ore_configured", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CommonRegistries.ORE_ICE_SHARD_LIST, 3));
        ModPlacements.AMBER_ORE_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:placement_amber_ore", ModConfiguredFeatures.CONFIGURED_AMBER_ORE, ConfiguredFeatureRegistries.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacements.ICE_SHARD_ORE_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:placement_ice_shard_ore", ModConfiguredFeatures.CONFIGURED_ICE_SHARD_ORE, ConfiguredFeatureRegistries.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModConfiguredFeatures.CONFIGURED_PEAT_DISK = FeatureUtils.m_206488_((String)"jurassicreborn:configured_peat_disk", (Feature)Feature.f_65781_, (FeatureConfiguration)new DiskConfiguration(((PeatBlock)((Object)ModBlocks.PEAT.get())).m_49966_(), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 2, List.of(Blocks.f_50493_.m_49966_(), Blocks.f_50440_.m_49966_())));
        ModPlacements.PEAT_DISK_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:placed_peat_disk", ModConfiguredFeatures.CONFIGURED_PEAT_DISK, List.of(RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        ModConfiguredFeatures.CONFIGURED_NEST_FOSSIL = FeatureUtils.m_206488_((String)"jurassicreborn:configured_nest_fossil", (Feature)((Feature)ModFeatures.NEST_FOSSIL_FEATURE.get()), (FeatureConfiguration)new NoneFeatureConfiguration());
        ModPlacements.NEST_FOSSIL_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:placed_nest_fossil", ModConfiguredFeatures.CONFIGURED_NEST_FOSSIL, ConfiguredFeatureRegistries.chancedOrePlacment((PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))));
        ModConfiguredFeatures.CONFIGURED_SMALL_PETRIFIED_TREE = FeatureUtils.m_206488_((String)"jurassicreborn:configured_small_petrified_tree", (Feature)((Feature)ModFeatures.PETRIFIED_TREE_GENERATOR.get()), (FeatureConfiguration)new PetrifiedTreeConfig(10, 0.2f));
        ModConfiguredFeatures.CONFIGURED_LARGE_PETRIFIED_TREE = FeatureUtils.m_206488_((String)"jurassicreborn:configured_large_petrified_tree", (Feature)((Feature)ModFeatures.PETRIFIED_TREE_GENERATOR.get()), (FeatureConfiguration)new PetrifiedTreeConfig(15, 0.1f));
        ModPlacements.PLACED_LARGE_PETRIFIED_TREE = PlacementUtils.m_206509_((String)"jurassicreborn:placed_large_petrified_tree", ModConfiguredFeatures.CONFIGURED_LARGE_PETRIFIED_TREE, ConfiguredFeatureRegistries.chancedOrePlacment((PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacements.PLACED_SMALL_PETRIFIED_TREE = PlacementUtils.m_206509_((String)"jurassicreborn:placed_small_petrified_tree", ModConfiguredFeatures.CONFIGURED_SMALL_PETRIFIED_TREE, ConfiguredFeatureRegistries.chancedOrePlacment((PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        CommonRegistries.ORE_GYPSUM_STONE_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((GypsumStoneBlock)((Object)ModBlocks.GYPSUM_STONE.get())).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((GypsumStoneBlock)((Object)ModBlocks.GYPSUM_STONE.get())).m_49966_()));
        ModConfiguredFeatures.CONFIGURED_GYPSUM_STONE = FeatureUtils.m_206488_((String)"jurassicreborn:gypsum_stone", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CommonRegistries.ORE_GYPSUM_STONE_LIST, 17));
        ModPlacements.GYPSUM_STONE_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:gypsum_stone_placed", ModConfiguredFeatures.CONFIGURED_GYPSUM_STONE, ConfiguredFeatureRegistries.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-80), (VerticalAnchor)VerticalAnchor.m_158922_((int)192))));
        ModConfiguredFeatures.CONFIGURED_GRACILARIA_PATCH = FeatureUtils.m_206488_((String)"jurassicreborn:gracilaria_patch", (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(64, 1, 0, PlacementUtils.m_206502_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)((GracilariaBlock)((Object)ModBlocks.GRACILARIA.get())).m_49966_())), (PlacementModifier[])new PlacementModifier[0])));
        ModPlacements.GRACILARIA_PATCH_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:gracilaria_patch_placed", ModConfiguredFeatures.CONFIGURED_GRACILARIA_PATCH, List.of(CountPlacement.m_191628_((int)1), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR), BiomeFilter.m_191561_()));
        ModConfiguredFeatures.CONFIGURED_HELICONIA_PATCH = FeatureUtils.m_206488_((String)"jurassicreborn:heliconia_patch", (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(96, 2, 3, PlacementUtils.m_206502_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)((BlockState)((HeliconiaBlock)((Object)ModBlocks.HELICONIA.get())).m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))), (PlacementModifier[])new PlacementModifier[0])));
        ModPlacements.HELICONIA_PATCH_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:heliconia_patch_placed", ModConfiguredFeatures.CONFIGURED_HELICONIA_PATCH, List.of(RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        ModConfiguredFeatures.CONFIGURED_WEST_INDIAN_LILAC_PATCH = FeatureUtils.m_206488_((String)"jurassicreborn:west_indian_lilac_patch", (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(96, 3, 3, PlacementUtils.m_206502_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)((BlockState)((BlockState)((WestIndianLilacBlock)((Object)ModBlocks.WEST_INDIAN_LILAC.get())).m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WestIndianLilacBlock.AGE, (Comparable)Integer.valueOf(0))))), (PlacementModifier[])new PlacementModifier[0])));
        ModPlacements.WEST_INDIAN_LILAC_PATCH_PLACEMENT = PlacementUtils.m_206509_((String)"jurassicreborn:west_indian_lilac_patch_placed", ModConfiguredFeatures.CONFIGURED_WEST_INDIAN_LILAC_PATCH, List.of(RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING), BiomeFilter.m_191561_()));
        ConfiguredFeatureRegistries.registerDinoFossils();
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> chancedOrePlacment(PlacementModifier p_195348_) {
        return List.of(InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return ConfiguredFeatureRegistries.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
    }

    private static void registerDinoFossils() {
        ModPlacements.DINO_FOSSIL_PLACEMENTS.clear();
        for (FossilOreDefinition fossil : DINO_FOSSILS) {
            ArrayList<OreConfiguration.TargetBlockState> targets = new ArrayList<OreConfiguration.TargetBlockState>();
            if (fossil.generateInStone()) {
                targets.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)fossil.block().get().m_49966_()));
            }
            if (fossil.generateInDeepslate()) {
                targets.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)fossil.block().get().m_49966_()));
            }
            if (targets.isEmpty()) continue;
            Holder configured = FeatureUtils.m_206488_((String)("jurassicreborn:" + fossil.name() + "_fossil"), (Feature)((Feature)ModFeatures.FOSSIL_ORE.get()), (FeatureConfiguration)new OreConfiguration(targets, fossil.size()));
            Holder placed = PlacementUtils.m_206509_((String)("jurassicreborn:" + fossil.name() + "_fossil_placed"), (Holder)configured, ConfiguredFeatureRegistries.commonOrePlacement(fossil.count(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)fossil.minY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)fossil.maxY()))));
            ModPlacements.DINO_FOSSIL_PLACEMENTS.add((Holder<PlacedFeature>)placed);
        }
    }

    private record FossilOreDefinition(String name, Supplier<? extends Block> block, int size, int count, int minY, int maxY, boolean generateInStone, boolean generateInDeepslate) {
    }
}

