/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    private final Item item;
    private final TagKey<Item> tag;
    private final float chance;
    private final int count;

    public AddItemModifier(LootItemCondition[] conditions, Item item, TagKey<Item> tag, float chance, int count) {
        super(conditions);
        this.item = item;
        this.tag = tag;
        this.chance = chance;
        this.count = count;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generated, LootContext ctx) {
        List pool;
        if (ctx.m_78933_().nextFloat() > this.chance) {
            return generated;
        }
        Item toAdd = this.item;
        if (toAdd == null && this.tag != null && !(pool = ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().toList()).isEmpty()) {
            toAdd = (Item)pool.get(ctx.m_78933_().nextInt(pool.size()));
        }
        if (toAdd != null) {
            generated.add(new ItemStack((ItemLike)toAdd, this.count));
        }
        return generated;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemModifier> {
        public AddItemModifier read(ResourceLocation location, JsonObject json, LootItemCondition[] conditions) {
            Item item = null;
            if (json.has("item")) {
                ResourceLocation itemId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
                item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            }
            TagKey tag = null;
            if (json.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagId);
            }
            float chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new AddItemModifier(conditions, item, (TagKey<Item>)tag, chance, count);
        }

        public JsonObject write(AddItemModifier instance) {
            ResourceLocation id;
            JsonObject json = this.makeConditions(instance.conditions);
            if (instance.item != null && (id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.item)) != null) {
                json.addProperty("item", id.toString());
            }
            if (instance.tag != null) {
                json.addProperty("tag", instance.tag.f_203868_().toString());
            }
            if (instance.chance != 1.0f) {
                json.addProperty("chance", (Number)Float.valueOf(instance.chance));
            }
            if (instance.count != 1) {
                json.addProperty("count", (Number)instance.count);
            }
            return json;
        }
    }
}

