/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.worldgen.structure.StructureGenerator;

public class JPSanDiegoGenerator
extends StructureGenerator {
    private static final ResourceLocation STRUCTURE = JurassicReborn.resource("jp_san_diego");
    private static final Map<String, ResourceLocation> LOOT_TABLES = new HashMap<String, ResourceLocation>();

    public JPSanDiegoGenerator(Random rand) {
        super(rand, 114, 108, 145);
    }

    @Override
    protected void generateStructure(ServerLevel level, Random random, BlockPos position) {
        StructureTemplate template = this.loadTemplate(level, STRUCTURE);
        if (template == null) {
            return;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74379_(this.rotation);
        settings.m_74377_(this.mirror);
        settings.m_74390_(random);
        template.m_74536_((ServerLevelAccessor)level, position, position, settings, random, 4);
        List dataBlocks = template.m_74603_(position, settings, Blocks.f_50677_);
        for (StructureTemplate.StructureBlockInfo info : dataBlocks) {
            String type = info.f_74677_.m_128461_("metadata");
            ResourceLocation lootTable = LOOT_TABLES.get(type);
            if (lootTable == null) continue;
            level.m_7731_(info.f_74675_, Blocks.f_50016_.m_49966_(), 3);
            BlockEntity tile = level.m_7702_(info.f_74675_.m_7495_());
            if (!(tile instanceof ChestBlockEntity)) continue;
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            chest.m_59626_(lootTable, random.nextLong());
        }
    }

    @Override
    public BlockPos getLevelPosition() {
        return new BlockPos(0, 54, 0);
    }

    static {
        LOOT_TABLES.put("GroundStorage", new ResourceLocation("jurassicreborn", "structure/visitor_centre/ground_storage"));
        LOOT_TABLES.put("ControlRoom", new ResourceLocation("jurassicreborn", "structure/visitor_centre/control_room"));
        LOOT_TABLES.put("Laboratory", new ResourceLocation("jurassicreborn", "structure/visitor_centre/laboratory"));
        LOOT_TABLES.put("Kitchen", new ResourceLocation("jurassicreborn", "structure/visitor_centre/kitchen"));
        LOOT_TABLES.put("DormTower", new ResourceLocation("jurassicreborn", "structure/visitor_centre/dorm_tower"));
        LOOT_TABLES.put("DiningHall", new ResourceLocation("jurassicreborn", "structure/visitor_centre/dining_hall"));
        LOOT_TABLES.put("Cryonics", new ResourceLocation("jurassicreborn", "structure/visitor_centre/cryonics"));
    }
}

