/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.vit.jurassicreborn.common.worldgen.structure.StructureGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.StructureUtils;

public enum StructureGenerationHandler {
    INSTANCE;

    private static final Map<Biome, List<GeneratorEntry>> GENERATORS;
    private static final List<GeneratorEntry> UNIVERSAL_GENERATORS;

    public void generate(ServerLevel level, Random random, BlockPos pos, Biome biome, StructureUtils.StructureData data) {
        List<GeneratorEntry> list;
        boolean universalGenerated = false;
        for (GeneratorEntry entry : UNIVERSAL_GENERATORS) {
            if (!entry.predicate.test(level, pos, random) || !entry.configPredicate.test(data)) continue;
            entry.generatorFunction.apply(random).generate(level, random, pos);
            universalGenerated = true;
        }
        if (!universalGenerated && (list = GENERATORS.get(biome)) != null && !list.isEmpty()) {
            GeneratorEntry entry;
            entry = list.get(random.nextInt(list.size()));
            if (entry.predicate.test(level, pos, random) && entry.configPredicate.test(data)) {
                entry.generatorFunction.apply(random).generate(level, random, pos);
            }
        }
    }

    public static void registerGenerator(Function<Random, StructureGenerator> generatorFunction, Predicate<StructureUtils.StructureData> configPredicate, int weight, Biome ... validBiomes) {
        StructureGenerationHandler.registerGenerator(generatorFunction, configPredicate, (level, pos, random) -> random.nextInt(weight) == 0, validBiomes);
    }

    public static void registerGenerator(Function<Random, StructureGenerator> generatorFunction, Predicate<StructureUtils.StructureData> configPredicate, StructurePredicate predicate, Biome ... validBiomes) {
        GeneratorEntry entry = new GeneratorEntry(generatorFunction, configPredicate, predicate);
        if (validBiomes.length == 0) {
            UNIVERSAL_GENERATORS.add(entry);
        } else {
            for (Biome biome : validBiomes) {
                GENERATORS.computeIfAbsent(biome, b -> new ArrayList()).add(entry);
            }
        }
    }

    static {
        GENERATORS = new HashMap<Biome, List<GeneratorEntry>>();
        UNIVERSAL_GENERATORS = new ArrayList<GeneratorEntry>();
    }

    private static class GeneratorEntry {
        private final Function<Random, StructureGenerator> generatorFunction;
        private final Predicate<StructureUtils.StructureData> configPredicate;
        private final StructurePredicate predicate;

        GeneratorEntry(Function<Random, StructureGenerator> generatorFunction, Predicate<StructureUtils.StructureData> configPredicate, StructurePredicate predicate) {
            this.generatorFunction = generatorFunction;
            this.configPredicate = configPredicate;
            this.predicate = predicate;
        }
    }

    @FunctionalInterface
    public static interface StructurePredicate {
        public boolean test(ServerLevel var1, BlockPos var2, Random var3);
    }
}

