/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.vit.jurassicreborn.common.blocks.wood.AncientLeavesBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.worldgen.tree.BaseTreeGenerator;
import net.vit.jurassicreborn.common.worldgen.tree.TreePlaceUtil;

public class CalamitesTreeGenerator
extends Feature<NoneFeatureConfiguration> {
    public CalamitesTreeGenerator(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState log = ((RotatedPillarBlock)WoodBlocks.CALAMITES_LOG.get()).m_49966_();
        BlockState leaves = (BlockState)((Block)WoodBlocks.CALAMITES_LEAVES.get()).m_49966_().m_61124_((Property)AncientLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1));
        WorldGenLevel world = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        int height = rand.nextInt(10) + 10;
        int branchIndex = 0;
        int halfDistance = height / 2;
        if (!this.canPlace(context, height, halfDistance)) {
            return false;
        }
        world.m_7731_(position, log, 19);
        for (int y = 0; y < height; ++y) {
            boolean branch;
            BlockPos logPos = position.m_6630_(y);
            BaseTreeGenerator.setBlockState(world, logPos, log);
            boolean upperHalf = y > halfDistance;
            if (++branchIndex > (upperHalf ? 2 : 3)) {
                branchIndex = 0;
            }
            boolean bl = upperHalf ? branchIndex >= 2 : (branch = branchIndex >= 3);
            if (!branch) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos branchPos = logPos.m_142300_(facing);
                BlockState facingLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)facing.m_122434_());
                BaseTreeGenerator.setBlockState(world, branchPos, facingLog);
                BaseTreeGenerator.setBlockState(world, branchPos.m_7494_(), leaves);
                int leaveOut = Math.max(1, (upperHalf ? -(halfDistance - y) : halfDistance - y + halfDistance) / 2) + (rand.nextInt(2) - 1);
                for (int i = 0; i < leaveOut; ++i) {
                    BlockPos leavePos = branchPos.m_5484_(facing, i + 1).m_6630_(i / 2 + 1);
                    BaseTreeGenerator.setBlockState(world, leavePos, leaves);
                    if (!upperHalf) {
                        if (i < leaveOut / 4 || height < 12) {
                            BaseTreeGenerator.setBlockState(world, leavePos.m_7494_(), leaves);
                        }
                        if (i < leaveOut - 2) {
                            BaseTreeGenerator.setBlockState(world, leavePos.m_7495_(), leaves);
                            BaseTreeGenerator.setBlockState(world, leavePos.m_142300_(facing.m_122428_()), leaves);
                            BaseTreeGenerator.setBlockState(world, leavePos.m_142300_(facing.m_122427_()), leaves);
                            continue;
                        }
                        if (i < leaveOut - 2) continue;
                        BaseTreeGenerator.setBlockState(world, leavePos.m_7494_(), leaves);
                        continue;
                    }
                    if (i < leaveOut - 1) continue;
                    BaseTreeGenerator.setBlockState(world, leavePos.m_7494_(), leaves);
                    BaseTreeGenerator.setBlockState(world, leavePos.m_6630_(1).m_142300_(facing), leaves);
                }
                if (!upperHalf) {
                    BaseTreeGenerator.setBlockState(world, branchPos.m_142300_(facing).m_7494_(), facingLog);
                    BaseTreeGenerator.setBlockState(world, branchPos.m_142300_(facing), leaves);
                    continue;
                }
                BaseTreeGenerator.setBlockState(world, branchPos.m_142300_(facing).m_6630_(2), leaves);
            }
        }
        for (int i = 0; i < height / 4 + 1; ++i) {
            BaseTreeGenerator.setBlockState(world, position.m_6630_(height + i), leaves);
        }
        return true;
    }

    private boolean canPlace(FeaturePlaceContext<NoneFeatureConfiguration> pContext, int height, int halfDistance) {
        BlockPos.MutableBlockPos min = pContext.m_159777_().m_122032_();
        min.m_122184_(-3, 0, -3);
        BlockPos.MutableBlockPos max = pContext.m_159777_().m_122032_();
        max.m_122184_(3, height, 3);
        for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y < max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                    if (TreePlaceUtil.validTreePos(pContext.m_159774_(), new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

