/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.vit.jurassicreborn.common.blocks.wood.AncientLeavesBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.worldgen.tree.BaseTreeGenerator;
import net.vit.jurassicreborn.common.worldgen.tree.TreePlaceUtil;

public class PsaroniusTreeGenerator
extends Feature<NoneFeatureConfiguration> {
    public PsaroniusTreeGenerator(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState log = ((RotatedPillarBlock)WoodBlocks.PSARONIUS_LOG.get()).m_49966_();
        BlockState leaves = (BlockState)((Block)WoodBlocks.PSARONIUS_LEAVES.get()).m_49966_().m_61124_((Property)AncientLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1));
        WorldGenLevel world = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        int scale = rand.nextInt(1) + 1;
        int height = scale + 6 + rand.nextInt(2);
        BlockPos topPosition = position.m_6630_(height);
        if (!this.canPlace(context, height, scale)) {
            return false;
        }
        world.m_7731_(position, log, 19);
        for (int y = 0; y < height; ++y) {
            BlockPos logPosition = position.m_6630_(y);
            BaseTreeGenerator.setBlockState(world, logPosition, log);
        }
        int leafScale = scale + 2;
        for (int x = -leafScale; x <= leafScale; ++x) {
            BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(x, 0, 0), leaves);
        }
        for (int z = -leafScale; z <= leafScale; ++z) {
            BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(0, 0, z), leaves);
        }
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(-leafScale - 1, -1, 0), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(leafScale + 1, -1, 0), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(0, -1, -leafScale - 1), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(0, -1, leafScale + 1), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(-2, -1, -2), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(-2, -1, 2), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(2, -1, 2), leaves);
        BaseTreeGenerator.setBlockState(world, topPosition.m_142082_(2, -1, -2), leaves);
        this.generateClump(world, topPosition, 2.5, leaves);
        return true;
    }

    private void generateClump(WorldGenLevel world, BlockPos pos, double size, BlockState state) {
        int blockRadius = (int)Math.ceil(size);
        for (int x = -blockRadius; x < blockRadius; ++x) {
            for (int y = -blockRadius; y < blockRadius; ++y) {
                for (int z = -blockRadius; z < blockRadius; ++z) {
                    BlockPos leafPos;
                    if (!((double)Math.abs(x * x + y * y + z * z) <= size) || !world.m_8055_(leafPos = pos.m_142082_(x, y, z)).m_60795_()) continue;
                    BaseTreeGenerator.setBlockState(world, leafPos, state);
                }
            }
        }
    }

    private boolean canPlace(FeaturePlaceContext<NoneFeatureConfiguration> pContext, int height, int branchHeight) {
        BlockPos.MutableBlockPos min = pContext.m_159777_().m_122032_();
        min.m_122184_(-3, branchHeight, -3);
        BlockPos.MutableBlockPos max = pContext.m_159777_().m_122032_();
        max.m_122184_(3, height + 4, 3);
        for (int y = 0; y < branchHeight + 5; ++y) {
            if (TreePlaceUtil.validTreePos(pContext.m_159774_(), pContext.m_159777_().m_6630_(y))) continue;
            return false;
        }
        for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y < max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                    if (TreePlaceUtil.validTreePos(pContext.m_159774_(), new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

