/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.vit.jurassicreborn.client.render.entity.model.JurassicBoatModelLayers;
import net.vit.jurassicreborn.common.entities.vehicle.boat.JurassicBoat;
import net.vit.jurassicreborn.common.entities.vehicle.boat.JurassicChestBoat;
import net.vit.jurassicreborn.common.entities.vehicle.boat.ModBoatType;

public class JurassicBoatRenderer<T extends Boat>
extends EntityRenderer<T> {
    private final Map<ModBoatType, Pair<ResourceLocation, BoatModel>> boatResources;
    private final boolean hasChest;

    public JurassicBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.hasChest = hasChest;
        this.f_114477_ = 0.8f;
        this.boatResources = Stream.of(ModBoatType.values()).collect(Collectors.toMap(type -> type, type -> Pair.of((Object)this.createTexture((ModBoatType)((Object)type)), (Object)this.createModel(context, (ModBoatType)((Object)type), hasChest)), (a, b) -> a, () -> new EnumMap(ModBoatType.class)));
    }

    private ResourceLocation createTexture(ModBoatType type) {
        String folder = this.hasChest ? "chest_boat" : "boat";
        return new ResourceLocation("jurassicreborn", "textures/entity/" + folder + "/" + type.m_7912_() + ".png");
    }

    private BoatModel createModel(EntityRendererProvider.Context context, ModBoatType type, boolean hasChest) {
        ModelLayerLocation layer = hasChest ? JurassicBoatModelLayers.createChestBoatModelName(type) : JurassicBoatModelLayers.createBoatModelName(type);
        ModelPart part = context.m_174023_(layer);
        return new BoatModel(part, hasChest);
    }

    public void render(T boat, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ModBoatType variant;
        Pair<ResourceLocation, BoatModel> pair;
        float bubbleAngle;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        float hurtTime = (float)boat.m_38385_() - partialTicks;
        float damage = boat.m_38384_() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)hurtTime) * hurtTime * damage / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = boat.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(bubbleAngle));
        }
        if (this.hasChest || boat instanceof JurassicChestBoat) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        if ((pair = this.boatResources.get((Object)(variant = this.resolveVariant(boat)))) == null) {
            pair = this.boatResources.get((Object)ModBoatType.ARAUCARIA);
        }
        if (pair == null) {
            poseStack.m_85849_();
            super.m_7392_(boat, yaw, partialTicks, poseStack, buffer, packedLight);
            return;
        }
        ResourceLocation texture = (ResourceLocation)pair.getFirst();
        BoatModel model = (BoatModel)pair.getSecond();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        model.m_6973_(boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vc = buffer.m_6299_(model.m_103119_(texture));
        model.m_7695_(poseStack, vc, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer waterMask = buffer.m_6299_(RenderType.m_110478_());
            model.m_102282_().m_104301_(poseStack, waterMask, packedLight, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        super.m_7392_(boat, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    private ModBoatType resolveVariant(T boat) {
        if (boat instanceof JurassicBoat) {
            JurassicBoat jb = (JurassicBoat)((Object)boat);
            return jb.getJurassicVariant();
        }
        if (boat instanceof JurassicChestBoat) {
            JurassicChestBoat jcb = (JurassicChestBoat)((Object)boat);
            return jcb.getJurassicVariant();
        }
        return ModBoatType.ARAUCARIA;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.createTexture(this.resolveVariant(entity));
    }
}

