/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.vit.jurassicreborn.common.entities.item.PaddockSignEntity;

public class PaddockSignRenderer
extends EntityRenderer<PaddockSignEntity> {
    public PaddockSignRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(PaddockSignEntity sign) {
        return sign.getTextureLocation(sign);
    }

    public void render(PaddockSignEntity sign, float yaw, float pt, PoseStack pose, MultiBufferSource buf, int light) {
        ResourceLocation tex = this.getTextureLocation(sign);
        float w = (float)sign.m_7076_() / 16.0f;
        float h = (float)sign.m_7068_() / 16.0f;
        pose.m_85836_();
        pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        pose.m_85837_((double)(-w / 2.0f), (double)(-h / 2.0f), 0.0);
        VertexConsumer vb = buf.m_6299_(RenderType.m_110458_((ResourceLocation)tex));
        float s = 0.01f;
        pose.m_85836_();
        pose.m_85837_(0.0, 0.0, (double)(-s));
        float zStart = 0.03f;
        float zEnd = 0.0f;
        int slices = 30;
        float step = (zEnd - zStart) / (float)(slices - 1);
        for (int i = 0; i < slices; ++i) {
            float z = zStart + (float)i * step;
            PaddockSignRenderer.drawQuad(pose, vb, 0.0f, 0.0f, w, h, z, light);
        }
        pose.m_85849_();
        pose.m_85849_();
    }

    private static void drawQuadBlack(PoseStack pose, VertexConsumer vb, float x0, float y0, float w, float h, float z, int light, boolean flipNormal) {
        float x1 = x0 + w;
        float y1 = y0 + h;
        PoseStack.Pose last = pose.m_85850_();
        Matrix4f m = last.m_85861_();
        Matrix3f n = last.m_85864_();
        float nz = flipNormal ? 1.0f : -1.0f;
        float u0 = 1.0f;
        float u1 = 0.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        vb.m_85982_(m, x0, y1, z).m_6122_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
        vb.m_85982_(m, x1, y1, z).m_6122_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
        vb.m_85982_(m, x1, y0, z).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
        vb.m_85982_(m, 0.0f, 0.0f, z).m_6122_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
    }

    private static void drawQuad(PoseStack pose, VertexConsumer vb, float x0, float y0, float w, float h, float z, int light) {
        PaddockSignRenderer.drawQuad(pose, vb, 0.0f, 0.0f, w, h, z, light, false);
    }

    private static void drawQuad(PoseStack pose, VertexConsumer vb, float x0, float y0, float w, float h, float z, int light, boolean flipNormal) {
        float x1 = x0 + w;
        float y1 = y0 + h;
        PoseStack.Pose last = pose.m_85850_();
        Matrix4f m = last.m_85861_();
        Matrix3f n = last.m_85864_();
        float nz = flipNormal ? 1.0f : -1.0f;
        float u0 = 1.0f;
        float u1 = 0.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        vb.m_85982_(m, x0, y1, z).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
        vb.m_85982_(m, x1, y1, z).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
        vb.m_85982_(m, x1, y0, z).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
        vb.m_85982_(m, 0.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(n, 0.0f, 0.0f, nz).m_5752_();
    }
}

