/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.SkullDisplayBlock;
import net.vit.jurassicreborn.common.blocks.entities.SkullDisplayBlockEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class SkullDisplayRenderer
implements BlockEntityRenderer<SkullDisplayBlockEntity> {
    public SkullDisplayRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SkullDisplayBlockEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean horizontal;
        BlockState state = tile.m_58900_();
        if (state.m_60734_() != ModBlocks.SKULL_DISPLAY.get()) {
            return;
        }
        boolean bl = horizontal = ((Direction)state.m_61143_((Property)SkullDisplayBlock.FACING)).m_122434_() == Direction.Axis.Y;
        if (tile.model == null && tile.hasData()) {
            try {
                String dino = tile.getDinosaur().getName().toLowerCase(Locale.ENGLISH).replace(' ', '_');
                String modelOrient = horizontal ? "horizontal" : "vertical";
                String textureOrient = horizontal ? "vertical" : "horizontal";
                TabulaModelContainer container = TabulaModelHelper.loadTabulaModel(new ResourceLocation("jurassicreborn", "models/block/skull_display/" + dino + "_" + modelOrient));
                tile.model = new TabulaModel(container);
                if (container != null && container.getScale() != null && container.getScale().length >= 3) {
                    tile.modelScale = new float[]{(float)container.getScale()[0], (float)container.getScale()[1], (float)container.getScale()[2]};
                }
                tile.texture = new ResourceLocation("jurassicreborn", "textures/block/skull_display/" + dino + "_" + (tile.isFossilized() ? "fossilized" : "fresh") + "_" + textureOrient + ".png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)tile.getAngle()));
        float sx = tile.modelScale[0];
        float sy = tile.modelScale[1];
        float sz = tile.modelScale[2];
        poseStack.m_85841_(1.6f * sx, -1.6f * sy, 1.6f * sz);
        if (!horizontal) {
            poseStack.m_85837_(0.0, (double)(0.15f * sy), (double)(-0.18f * sz));
        }
        poseStack.m_85837_(0.0, (double)(-1.194f * sy), 0.0);
        if (tile.model != null) {
            VertexConsumer vc = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)tile.texture));
            tile.model.m_7695_(poseStack, vc, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }
}

