/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vit.jurassicreborn.client.render.item.StorageDiscBakedModel;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscModelData;

@Mod.EventBusSubscriber(modid="jurassicreborn", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class StorageDiscModelHandler {
    private StorageDiscModelHandler() {
    }

    @SubscribeEvent
    public static void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        Int2ObjectMap<ResourceLocation> models = StorageDiscModelData.getModels();
        for (Int2ObjectMap.Entry entry : models.int2ObjectEntrySet()) {
            event.register((ResourceLocation)new ModelResourceLocation((ResourceLocation)entry.getValue(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onBakingCompleted(ModelEvent.BakingCompleted event) {
        ModelResourceLocation storageDisc = new ModelResourceLocation(new ResourceLocation("jurassicreborn", "storage_disc"), "inventory");
        Map models = event.getModels();
        BakedModel baseModel = (BakedModel)models.get(storageDisc);
        if (baseModel == null) {
            return;
        }
        Int2ObjectMap<ResourceLocation> modelLocations = StorageDiscModelData.getModels();
        ObjectIterator it = modelLocations.int2ObjectEntrySet().iterator();
        Int2ObjectArrayMap bakedVariants = new Int2ObjectArrayMap();
        while (it.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it.next();
            ModelResourceLocation loc = new ModelResourceLocation((ResourceLocation)entry.getValue(), "inventory");
            BakedModel variant = (BakedModel)models.get(loc);
            if (variant == null) continue;
            bakedVariants.put(entry.getIntKey(), (Object)variant);
        }
        StorageDiscBakedModel wrapped = new StorageDiscBakedModel(baseModel, (Int2ObjectMap<BakedModel>)bakedVariants);
        models.put(storageDisc, wrapped);
    }
}

