/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.vit.jurassicreborn.common.items.JournalItem;

public class JournalGui
extends Screen {
    private static final int SIZE_X = 256;
    private static final int SIZE_Y = 192;
    private static final float FONT_SCALE = 1.0f;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jurassicreborn", "textures/journal/background.png");
    private static final ResourceLocation WIDGETS = new ResourceLocation("jurassicreborn", "textures/journal/widgets.png");
    private final JournalItem.JournalType type;
    private final JournalItem.Content content;
    private String[][] pages;
    private int pageCount;
    private int page = 0;
    private PageButton nextButton;
    private PageButton prevButton;

    public JournalGui(JournalItem.JournalType type) {
        super((Component)Component.m_237113_((String)""));
        this.type = type;
        this.content = type.getContent();
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 192) / 2;
        this.nextButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(x + 235, y + 180, true, btn -> {
            if (this.page < this.pageCount - 1) {
                ++this.page;
                this.updateButtons();
            }
        }));
        this.prevButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(x - 3, y + 180, false, btn -> {
            if (this.page > 0) {
                --this.page;
                this.updateButtons();
            }
        }));
        ArrayList<String> lines = new ArrayList<String>();
        for (String[] entry : this.content.getEntries()) {
            String[] stringArray = entry;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String raw;
                String line = raw = stringArray[i];
                ArrayList<JournalFormatting> formats = new ArrayList<JournalFormatting>();
                for (JournalFormatting fmt : JournalFormatting.values()) {
                    line = fmt.apply(line, formats);
                }
                float scale = 1.0f;
                for (JournalFormatting fmt : formats) {
                    scale *= fmt.getScaleModifier();
                }
                StringBuilder current = new StringBuilder();
                for (String word : line.split("\\s")) {
                    if ((float)this.f_96547_.m_92895_(current.toString() + word) * scale > 94.0f) {
                        lines.add(JournalFormatting.format(current.toString(), formats));
                        current = new StringBuilder();
                    }
                    current.append(word).append(" ");
                }
                lines.add(JournalFormatting.format(current.toString(), formats));
            }
            lines.add("\n");
        }
        ArrayList<String[]> pageList = new ArrayList<String[]>();
        ArrayList<String> currentPage = new ArrayList<String>();
        int yOff = 0;
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = (int)(9.0f * 1.0f + 2.0f);
        for (String line : lines) {
            boolean newPage = line.endsWith("\n");
            if (!newPage) {
                currentPage.add(line);
            }
            if ((yOff += lineHeight) <= 140 && !newPage) continue;
            pageList.add(currentPage.toArray(new String[0]));
            currentPage.clear();
            yOff = 0;
        }
        this.pages = (String[][])pageList.toArray((T[])new String[0][]);
        this.pageCount = Mth.m_14167_((float)((float)this.pages.length / 2.0f));
        this.updateButtons();
    }

    private void updateButtons() {
        this.nextButton.f_93624_ = this.page < this.pageCount - 1;
        this.prevButton.f_93624_ = this.page > 0;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 192) / 2;
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(pose, x, y, 0, 0, 256, 192);
        this.drawPage(pose, this.page * 2, x + 18, y + 16);
        this.drawPage(pose, this.page * 2 + 1, x + 145, y + 16);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
    }

    private void drawPage(PoseStack pose, int index, int ox, int oy) {
        if (index >= 0 && index < this.pages.length) {
            int yOff = 0;
            Objects.requireNonNull(this.f_96547_);
            int lh = (int)(9.0f * 1.0f + 2.0f);
            for (String line : this.pages[index]) {
                this.drawScaledString(pose, line, ox, oy + yOff, 1.0f, 0);
                yOff += lh;
            }
        }
    }

    private void drawScaledString(PoseStack pose, String text, float x, float y, float scale, int color) {
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        this.f_96547_.m_92883_(pose, text, x / scale, y / scale, color);
        pose.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    private static class PageButton
    extends Button {
        private final boolean isForward;

        public PageButton(int x, int y, boolean forward, Button.OnPress onPress) {
            super(x, y, 23, 13, (Component)Component.m_237119_(), onPress);
            this.isForward = forward;
        }

        public void m_6303_(PoseStack pose, int mx, int my, float pt) {
            if (this.f_93624_) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
                boolean hover = this.m_5953_(mx, my);
                int u = hover ? 23 : 0;
                int v = this.isForward ? 194 : 207;
                this.m_93228_(pose, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
            }
        }
    }

    private static enum JournalFormatting {
        BOLD("*", ChatFormatting.BOLD, 1.15f),
        ITALIC("_", ChatFormatting.ITALIC, 1.0f);

        private final String id;
        private final ChatFormatting fmt;
        private final float scaleModifier;

        private JournalFormatting(String id, ChatFormatting fmt, float scaleModifier) {
            this.id = id;
            this.fmt = fmt;
            this.scaleModifier = scaleModifier;
        }

        public static String format(String text, List<JournalFormatting> fmts) {
            for (JournalFormatting f : fmts) {
                text = f.fmt + (String)text;
            }
            return ((String)text).replace("\\\\", "");
        }

        public String apply(String text, List<JournalFormatting> fmts) {
            if (text.startsWith(this.id)) {
                fmts.add(this);
                return text.substring(this.id.length());
            }
            return text;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }
    }
}

