/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.network.PaddockSignPlacePacket;

public class SelectDinosaurScreen
extends Screen {
    private final BlockPos signPos;
    private final Direction face;
    private final InteractionHand hand;
    private List<Integer> dinoIds;
    private int page = 0;
    private static final int COLUMNS = 4;
    private static final int ROWS = 5;
    private static final int PER_PAGE = 20;

    public SelectDinosaurScreen(BlockPos pos, Direction face, InteractionHand hand) {
        super((Component)Component.m_237113_((String)"Select Dinosaur"));
        this.signPos = pos;
        this.face = face;
        this.hand = hand;
    }

    protected void m_7856_() {
        DinosaurHandler.doDinosInit();
        this.dinoIds = DinosaurHandler.getRegisteredIds();
        this.page = 0;
        this.buildPage();
    }

    private void buildPage() {
        this.m_169413_();
        int gridWidth = 320;
        int gridHeight = 100;
        int startX = (this.f_96543_ - gridWidth) / 2;
        int startY = (this.f_96544_ - gridHeight) / 2;
        int startIndex = this.page * 20;
        int endIndex = Math.min(startIndex + 20, this.dinoIds.size());
        int idx = startIndex;
        for (int row = 0; row < 5 && idx < endIndex; ++row) {
            for (int col = 0; col < 4 && idx < endIndex; ++idx, ++col) {
                int id = this.dinoIds.get(idx);
                Dinosaur d = DinosaurHandler.getById(id);
                String name = d == Dinosaur.EMPTY ? "None" : d.getName();
                int x = startX + col * 80;
                int y = startY + row * 20;
                int selectedId = id;
                this.m_142416_((GuiEventListener)new Button(x, y, 80, 20, (Component)Component.m_237113_((String)name), btn -> {
                    Network.sendToServer(new PaddockSignPlacePacket(this.signPos, this.face, this.hand, selectedId));
                    this.f_96541_.m_91152_(null);
                }));
            }
        }
        int totalPages = (this.dinoIds.size() + 20 - 1) / 20;
        this.m_142416_((GuiEventListener)new Button(startX, startY + gridHeight + 5, 20, 20, (Component)Component.m_237113_((String)"<"), btn -> {
            this.page = (this.page - 1 + totalPages) % totalPages;
            this.buildPage();
        }));
        this.m_142416_((GuiEventListener)new Button(startX + gridWidth - 20, startY + gridHeight + 5, 20, 20, (Component)Component.m_237113_((String)">"), btn -> {
            this.page = (this.page + 1) % totalPages;
            this.buildPage();
        }));
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float ptt) {
        this.m_7333_(ms);
        int gridHeight = 100;
        int startY = (this.f_96544_ - gridHeight) / 2;
        SelectDinosaurScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(startY - 20), (int)0xFFFFFF);
        int totalPages = (this.dinoIds.size() + 20 - 1) / 20;
        SelectDinosaurScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Component.m_237113_((String)(this.page + 1 + "/" + totalPages)), (int)(this.f_96543_ / 2), (int)(startY + gridHeight + 10), (int)0xFFFFFF);
        super.m_6305_(ms, mouseX, mouseY, ptt);
    }

    public boolean m_6913_() {
        return true;
    }
}

