/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public final class RebornConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final Common COMMON;
    public static boolean allowCarcass;
    public static boolean enableVehicleTilting;
    public static boolean attackOnlyWhenHungry;
    public static boolean spawnCrabs;
    public static boolean spawnSharks;
    public static boolean spawnGoats;
    public static final EntityBlacklist ENTITY_BLACKLIST;

    private RebornConfig() {
    }

    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            RebornConfig.sync();
        }
    }

    public static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            RebornConfig.sync();
        }
    }

    private static void sync() {
        allowCarcass = (Boolean)RebornConfig.COMMON.allowCarcass.get();
        enableVehicleTilting = (Boolean)RebornConfig.COMMON.enableVehicleTilting.get();
        attackOnlyWhenHungry = (Boolean)RebornConfig.COMMON.attackOnlyWhenHungry.get();
        spawnCrabs = (Boolean)RebornConfig.COMMON.spawnCrabs.get();
        spawnSharks = (Boolean)RebornConfig.COMMON.spawnSharks.get();
        spawnGoats = (Boolean)RebornConfig.COMMON.spawnGoats.get();
        List blacklist = (List)RebornConfig.COMMON.entityBlacklist.get();
        RebornConfig.ENTITY_BLACKLIST.blacklist = blacklist.toArray(new String[0]);
    }

    static {
        allowCarcass = true;
        enableVehicleTilting = true;
        attackOnlyWhenHungry = false;
        spawnCrabs = true;
        spawnSharks = true;
        spawnGoats = true;
        ENTITY_BLACKLIST = new EntityBlacklist();
        Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class Common {
        final ForgeConfigSpec.BooleanValue allowCarcass;
        final ForgeConfigSpec.BooleanValue enableVehicleTilting;
        final ForgeConfigSpec.BooleanValue attackOnlyWhenHungry;
        final ForgeConfigSpec.BooleanValue spawnCrabs;
        final ForgeConfigSpec.BooleanValue spawnSharks;
        final ForgeConfigSpec.BooleanValue spawnGoats;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlacklist;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration for Jurassic Reborn").push("general");
            this.allowCarcass = builder.comment("Determines if dinosaurs should become carcasses instead of dying instantly.").define("allowCarcass", true);
            this.enableVehicleTilting = builder.comment("Enable tilting animations for vehicles such as cars.").define("enableVehicleTilting", true);
            this.attackOnlyWhenHungry = builder.comment("If true, carnivores will only attack when hungry.").define("attackOnlyWhenHungry", false);
            this.spawnCrabs = builder.comment("Enable natural spawning for crabs.").define("spawnCrabs", true);
            this.spawnSharks = builder.comment("Enable natural spawning for sharks.").define("spawnSharks", true);
            this.spawnGoats = builder.comment("Enable natural spawning for goats.").define("spawnGoats", true);
            this.entityBlacklist = builder.comment(new String[]{"Entities that cages should refuse to capture.", "Use fully qualified entity IDs, e.g. minecraft:pig"}).defineList("entityBlacklist", List.of(), value -> value instanceof String);
            builder.pop();
        }
    }

    public static class EntityBlacklist {
        public String[] blacklist = new String[0];
    }
}

