/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MoganopterusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MoganopterusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public MoganopterusDinosaur() {
        this.setName("Moganopterus");
        this.setScientificName("Moganopterus zhuiana");
        this.setFamily("Tapejaridae");
        this.setLocation("China");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(MoganopterusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(15131352, 14057308);
        this.setEggColorFemale(14737107, 13859672);
        this.setHealth(4.0, 20.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(1.0, 5.0);
        this.setMaximumAge(this.fromDays(40));
        this.setEyeHeight(0.35f, 1.25f);
        this.setSizeX(0.15f, 1.0f);
        this.setSizeY(0.35f, 1.35f);
        this.setStorage(27);
        this.setDiet(Diet.PISCIVORE.get());
        this.setBones("leg_bones", "pelvis", "ribcage", "skull", "tail_vertebrae", "teeth", "wing_bones");
        this.setHeadCubeName("Head");
        this.setScale(0.725f, 0.1f);
        this.setAttackBias(200.0);
        this.setAvianAnimal(true);
        this.setBreeding(false, 2, 6, 80, false, true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "skull", "teeth"}, {"", "leg_bones", "wing_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_215816_, BiomeTags.f_207606_, BiomeTags.f_207607_, BiomeTags.f_207610_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

