/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class RaptorLeapEntityAI
extends Goal {
    private final DinosaurEntity entity;
    private LivingEntity target;
    private int prevTick;
    private EntityAnimation animation;
    private double targetPrevPosX;
    private double targetPrevPosZ;
    private boolean ticked = false;

    public RaptorLeapEntityAI(DinosaurEntity entity) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        DinosaurEntity d;
        if (this.entity.herd != null && this.entity.herd.fleeing) {
            return false;
        }
        LivingEntity tgt = this.entity.m_5448_();
        if (tgt == null || !tgt.m_6084_()) {
            return false;
        }
        if (tgt instanceof DinosaurEntity && (d = (DinosaurEntity)tgt).isCarcass()) {
            return false;
        }
        float distance = this.entity.m_20270_((Entity)tgt);
        if (!(distance >= 5.0f) || !(distance <= 6.0f)) {
            return false;
        }
        if (!this.entity.m_20096_()) {
            return false;
        }
        Vec3 from = new Vec3(this.entity.m_20185_(), this.entity.m_20188_(), this.entity.m_20189_());
        BlockHitResult hit = this.entity.f_19853_.m_45547_(new ClipContext(from, tgt.m_20182_(), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this.entity));
        if (hit != null && hit.m_6662_() == HitResult.Type.BLOCK) {
            return false;
        }
        this.target = tgt;
        return true;
    }

    public void m_8056_() {
        this.animation = EntityAnimation.PREPARE_LEAP;
        this.entity.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        this.entity.m_21573_().m_26573_();
        if (!this.entity.f_19853_.f_46443_) {
            this.entity.m_20256_(Vec3.f_82478_);
        }
        this.ticked = false;
    }

    public void m_8037_() {
        int tick = this.entity.getAnimationTick();
        this.entity.m_21573_().m_26573_();
        this.entity.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (this.animation == EntityAnimation.PREPARE_LEAP && tick < this.prevTick) {
            this.animation = EntityAnimation.LEAP;
            this.entity.m_5496_(this.entity.getSoundForAnimation(EntityAnimation.ATTACKING.get()), this.entity.m_6121_(), this.entity.m_6100_());
            double targetSpeedX = this.target.m_20185_() - (!this.ticked ? this.target.f_19790_ : this.targetPrevPosX);
            double targetSpeedZ = this.target.m_20189_() - (!this.ticked ? this.target.f_19792_ : this.targetPrevPosZ);
            double length = this.entity.m_20205_() * 6.0f;
            double destX = this.target.m_20185_() + targetSpeedX * length;
            double destZ = this.target.m_20189_() + targetSpeedZ * length;
            double dx = destX - this.entity.m_20185_();
            double dz = destZ - this.entity.m_20189_();
            double delta = Math.sqrt(dx * dx + dz * dz);
            double angle = Math.atan2(dz, dx);
            double mx = delta / length * Math.cos(angle);
            double mz = delta / length * Math.sin(angle);
            double my = Math.min(0.3, Math.max(0.0, (this.target.m_20186_() - this.entity.m_20186_()) * 0.1)) + 0.6;
            if (!this.entity.f_19853_.f_46443_) {
                this.entity.m_20334_(mx, my, mz);
                this.entity.f_19812_ = true;
            }
        } else if (this.animation == EntityAnimation.LEAP && this.entity.m_20184_().f_82480_ < 0.0) {
            this.animation = EntityAnimation.LEAP_LAND;
        } else if (this.animation == EntityAnimation.LEAP_LAND && (this.entity.m_20096_() || this.entity.m_6069_())) {
            this.animation = EntityAnimation.IDLE;
            if (this.entity.m_20191_() != null && this.target.m_20191_() != null && this.entity.m_20191_().m_82381_(this.target.m_20191_().m_82377_(2.0, 2.0, 2.0))) {
                this.entity.m_7327_((Entity)this.target);
            }
        }
        this.targetPrevPosX = this.target.m_20185_();
        this.targetPrevPosZ = this.target.m_20189_();
        this.ticked = true;
        if (this.entity.getAnimation() != this.animation.get()) {
            this.entity.setAnimation(this.animation.get());
            this.entity.setAnimationTick(this.prevTick + 1);
        }
        this.prevTick = tick;
    }

    public void m_8041_() {
        this.entity.setAnimation(EntityAnimation.IDLE.get());
    }

    public boolean m_8045_() {
        DinosaurEntity d;
        LivingEntity livingEntity;
        return this.target != null && this.target.m_6084_() && (!((livingEntity = this.target) instanceof DinosaurEntity) || !(d = (DinosaurEntity)livingEntity).isCarcass()) && this.animation != EntityAnimation.IDLE;
    }
}

