/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurJumpHelper;

public class DinosaurMoveHelper
extends MoveControl {
    private final DinosaurEntity dinosaur;

    public DinosaurMoveHelper(DinosaurEntity entity) {
        super((Mob)entity);
        this.dinosaur = entity;
    }

    public void m_8126_() {
        float baseSpeed = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
        PathNavigation navigator = this.f_24974_.m_21573_();
        NodeEvaluator nodeEvaluator = navigator != null ? navigator.m_26575_() : null;
        switch (this.f_24981_) {
            case STRAFE: {
                BlockPathTypes type;
                float moveSpeed = (float)(this.f_24978_ * (double)baseSpeed);
                float forward = this.f_24979_;
                float strafe = this.f_24980_;
                float len = Mth.m_14116_((float)(forward * forward + strafe * strafe));
                if (len < 1.0f) {
                    len = 0.8f;
                }
                float scale = moveSpeed / len;
                float yawRad = this.f_24974_.m_146908_() * ((float)Math.PI / 180);
                float sin = Mth.m_14031_((float)yawRad);
                float cos = Mth.m_14089_((float)yawRad);
                float mx = (forward *= scale) * cos - (strafe *= scale) * sin;
                float mz = strafe * cos + forward * sin;
                if (nodeEvaluator != null && (type = nodeEvaluator.m_8086_((BlockGetter)this.f_24974_.f_19853_, Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)mx)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)mz)))) != BlockPathTypes.WALKABLE) {
                    this.f_24979_ = 0.9f;
                    this.f_24980_ = 0.0f;
                    moveSpeed = baseSpeed;
                }
                this.f_24974_.m_7910_(moveSpeed);
                this.f_24974_.m_21564_(this.f_24979_);
                this.f_24974_.m_21570_(this.f_24980_);
                this.f_24981_ = MoveControl.Operation.WAIT;
                break;
            }
            case MOVE_TO: {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double dx = this.f_24975_ - this.f_24974_.m_20185_();
                double dz = this.f_24977_ - this.f_24974_.m_20189_();
                double dy = this.f_24976_ - this.f_24974_.m_20186_();
                double d2 = dx * dx + dy * dy + dz * dz;
                if (d2 < 2.5000003E-7) {
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float desiredYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), desiredYaw, 60.0f));
                this.f_24974_.m_7910_((float)(this.f_24978_ * (double)baseSpeed));
                float stepHeight = this.f_24974_.getStepHeight();
                if (!(dy > (double)stepHeight) || !(dx * dx + dz * dz < Math.max(1.0, (double)this.f_24974_.m_20205_() + dy * dy))) break;
                JumpControl jumpHelper = this.f_24974_.m_21569_();
                if (jumpHelper instanceof DinosaurJumpHelper && !this.f_24974_.m_20077_() && !this.f_24974_.m_20069_()) {
                    ((DinosaurJumpHelper)jumpHelper).jump((int)Math.ceil(dy));
                    break;
                }
                jumpHelper.m_24901_();
                break;
            }
            case JUMPING: {
                this.f_24974_.m_7910_((float)(this.f_24978_ * (double)baseSpeed));
                if (!this.f_24974_.m_20096_()) break;
                this.f_24981_ = MoveControl.Operation.WAIT;
                break;
            }
            case WAIT: {
                this.f_24974_.m_21564_(0.0f);
                this.f_24974_.m_21570_(0.0f);
            }
        }
    }

    private boolean isWalkableRelative(float relX, float relZ) {
        PathNavigation nav = this.f_24974_.m_21573_();
        if (nav == null) {
            return true;
        }
        NodeEvaluator eval = nav.m_26575_();
        if (eval == null) {
            return true;
        }
        BlockPos probe = new BlockPos(Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)relX)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)relZ)));
        return eval.m_8086_((BlockGetter)this.f_24974_.f_19853_, probe.m_123341_(), probe.m_123342_(), probe.m_123343_()) == BlockPathTypes.WALKABLE;
    }
}

