/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.Fossils;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.TabHandler;
import net.vit.jurassicreborn.common.items.genetics.SoftTissueItem;
import net.vit.jurassicreborn.common.util.api.GrindableItem;

public class FossilizedEggItem
extends Item
implements GrindableItem {
    public FossilizedEggItem() {
        super(new Item.Properties().m_41491_(TabHandler.FOSSILS));
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        CompoundTag tag = stack.m_41783_();
        int outputType = random.nextInt(3);
        if (outputType == 0) {
            List<Dinosaur> dinosaurs = DinosaurHandler.getDinosaursFromAmber();
            dinosaurs.removeIf(dino -> dino.isMammal() || dino.isHybrid());
            Dinosaur selected = dinosaurs.get(random.nextInt(dinosaurs.size()));
            ItemStack tissue = new ItemStack((ItemLike)ModItems.SOFT_TISSUE.get(selected).get());
            tissue.m_41751_(tag);
            return tissue;
        }
        if (outputType == 1) {
            return new ItemStack((ItemLike)Items.f_42499_);
        }
        return new ItemStack((ItemLike)Items.f_42484_);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        CompoundTag tag = inputItem.m_41783_();
        List<Dinosaur> dinosaurs = DinosaurHandler.getDinosaursFromAmber();
        float single = 33.333332f;
        float dinoSingle = single / (float)dinosaurs.size();
        for (Dinosaur dino : dinosaurs) {
            RegistryObject<SoftTissueItem> regObj = ModItems.SOFT_TISSUE.get(dino);
            if (regObj == null) continue;
            ItemStack output = new ItemStack((ItemLike)regObj.get());
            output.m_41751_(tag);
            list.add(Pair.of((Object)Float.valueOf(dinoSingle), (Object)output));
        }
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack((ItemLike)Items.f_42499_)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack((ItemLike)Items.f_42484_)));
        return list;
    }
}

