/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.Fossils;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.items.TabHandler;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.util.api.GrindableItem;

public class PlantFossilItem
extends Item
implements GrindableItem {
    public PlantFossilItem() {
        super(new Item.Properties().m_41491_(TabHandler.FOSSILS));
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        CompoundTag tag = stack.m_41783_();
        int outputType = random.nextInt(4);
        if (outputType == 3) {
            List<Plant> prehistoricPlants = PlantHandler.getPrehistoricPlants();
            Plant plant = prehistoricPlants.get(random.nextInt(prehistoricPlants.size()));
            String id = plant.getFormattedName().toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            ResourceLocation tissueId = new ResourceLocation("jurassicreborn", "soft_tissue/plants/soft_tissue_" + id);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(tissueId);
            if (item == null || item == Items.f_41852_) {
                return new ItemStack((ItemLike)Items.f_42484_);
            }
            ItemStack output = new ItemStack((ItemLike)item);
            output.m_41751_(tag);
            return output;
        }
        if (outputType < 2) {
            return new ItemStack((ItemLike)Items.f_42499_);
        }
        return new ItemStack((ItemLike)Items.f_42484_);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        List<Plant> prehistoricPlants = PlantHandler.getPrehistoricPlants();
        CompoundTag tag = inputItem.m_41783_();
        float single = 25.0f;
        float plantSingle = single / (float)prehistoricPlants.size();
        for (Plant plant : prehistoricPlants) {
            String id = plant.getFormattedName().toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            ResourceLocation tissueId = new ResourceLocation("jurassicreborn", "soft_tissue/plants/soft_tissue_" + id);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(tissueId);
            if (item == null || item == Items.f_41852_) continue;
            ItemStack output = new ItemStack((ItemLike)item);
            output.m_41751_(tag);
            list.add(Pair.of((Object)Float.valueOf(plantSingle), (Object)output));
        }
        list.add(Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack((ItemLike)Items.f_42499_)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack((ItemLike)Items.f_42484_)));
        return list;
    }
}

