/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.TabHandler;
import net.vit.jurassicreborn.common.items.genetics.DNAContainerItem;
import net.vit.jurassicreborn.common.util.LangUtil;
import org.jetbrains.annotations.Nullable;

public class DNAItem
extends DNAContainerItem {
    public final Dinosaur dinosaur;

    public DNAItem(Item.Properties pProperties, Dinosaur dino) {
        super(pProperties);
        this.dinosaur = dino;
    }

    public Component m_7626_(ItemStack pStack) {
        return LangUtil.replaceWithDinoName(this.dinosaur, "item.JurassicReborn.dna");
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        Dinosaur dinosaur = null;
        Item item = stack.m_41720_();
        if (item instanceof DNAItem) {
            DNAItem dna = (DNAItem)item;
            dinosaur = dna.dinosaur;
        }
        if (dinosaur == null) {
            dinosaur = Dinosaur.EMPTY;
        }
        return dinosaur;
    }

    @Override
    public int getContainerId(ItemStack stack) {
        return Dinosaur.DINOS.indexOf(this.getDinosaur(stack));
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
        if (pCategory == TabHandler.DNA || pCategory == CreativeModeTab.f_40754_) {
            if (pItems.stream().anyMatch(stack -> stack.m_150930_((Item)this))) {
                return;
            }
            RegistryObject<DNAItem> eggItem = ModItems.DINOSAUR_DNA.get(this.dinosaur);
            if (eggItem != null) {
                ItemStack defaultDNAItem = ((DNAItem)((Object)eggItem.get())).m_7968_();
                defaultDNAItem.m_41784_().m_128379_("isCreative", true);
                pItems.add((Object)defaultDNAItem);
            }
        } else {
            super.m_6787_(pCategory, pItems);
        }
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> lore, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, lore, pIsAdvanced);
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        String genetics = "ACGTACGTACGTACGTACGTACGTACGTAC";
        new DinoDNA(this.dinosaur, 100, genetics).writeToNBT(stack.m_41784_());
        return stack;
    }
}

