/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.TabHandler;
import net.vit.jurassicreborn.common.items.genetics.DNAContainerItem;
import net.vit.jurassicreborn.common.util.LangUtil;
import org.jetbrains.annotations.Nullable;

public class HatchedEggItem
extends DNAContainerItem {
    private final Dinosaur dino;

    public HatchedEggItem(Item.Properties properties, Dinosaur dino) {
        super(properties);
        this.dino = dino;
    }

    public Component m_7626_(ItemStack pStack) {
        return Component.m_237113_((String)Component.m_237115_((String)(this.dino.givesDirectBirth() ? "item.JurassicReborn.gestated" : "item.JurassicReborn.hatched_egg")).getString().replace("{dino}", LangUtil.getDinoName(this.dino).getString()));
    }

    public boolean getGender(@Nullable Player player, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Gender")) {
            return nbt.m_128471_("Gender");
        }
        boolean gender = player != null ? player.f_19853_.f_46441_.m_188499_() : (stack.hashCode() & 1) == 0;
        nbt.m_128379_("Gender", gender);
        stack.m_41751_(nbt);
        return gender;
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
        if (pCategory == TabHandler.DNA || pCategory == CreativeModeTab.f_40754_) {
            if (pItems.stream().anyMatch(stack -> stack.m_150930_((Item)this))) {
                return;
            }
            RegistryObject<HatchedEggItem> eggItem = ModItems.hatchedDinoEggs.get(this.dino);
            if (eggItem != null) {
                ItemStack defaultDNAItem = ((HatchedEggItem)((Object)eggItem.get())).m_7968_();
                defaultDNAItem.m_41784_().m_128379_("isCreative", true);
                pItems.add((Object)defaultDNAItem);
            }
        } else {
            super.m_6787_(pCategory, pItems);
        }
    }

    @Override
    public int getContainerId(ItemStack stack) {
        return Dinosaur.DINOS.indexOf(this.dino);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        Direction side = context.m_43719_();
        Player player = context.m_43723_();
        double hitX = context.m_43720_().f_82479_;
        double hitY = context.m_43720_().f_82480_;
        double hitZ = context.m_43720_().f_82481_;
        if (side == Direction.EAST || side == Direction.WEST) {
            hitX = 1.0 - hitX;
        } else if (side == Direction.NORTH || side == Direction.SOUTH) {
            hitZ = 1.0 - hitZ;
        }
        if (level.m_46739_(pos)) {
            Dinosaur dinosaur = this.dino;
            DinosaurEntity entity = (DinosaurEntity)((EntityType)DinosaurEntity.CLASS_TYPE_LIST.get(dinosaur.getDinosaurClass()).get()).m_20615_(level);
            if (entity == null) {
                return InteractionResult.PASS;
            }
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                entity.m_6518_((ServerLevelAccessor)sl, sl.m_6436_(entity.m_20183_()), MobSpawnType.SPAWN_EGG, null, null);
            }
            entity.setAge(0);
            entity.setGenetics(HatchedEggItem.getGeneticCode(player != null ? player.m_217043_() : level.f_46441_, stack));
            entity.setDNAQuality(HatchedEggItem.getDNAQuality(player != null && player.m_7500_(), stack));
            entity.setMale(this.getGender(player, stack));
            if (player != null && !player.m_6047_()) {
                entity.setOwner(player);
            }
            level.m_7967_((Entity)entity);
            if (player != null && !player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> lore, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, lore, pIsAdvanced);
        CompoundTag tag = pStack.m_41783_();
        if (tag != null && tag.m_128441_("Gender")) {
            lore.add((Component)Component.m_237115_((String)("tooltip.jurassicreborn.gender." + (tag.m_128471_("Gender") ? "male" : "female"))));
        }
    }
}

