/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.vit.jurassicreborn.common.blocks.ancientplants.AncientCrop;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.TabHandler;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.util.LangUtil;

public class PlantCallusItem
extends Item {
    public PlantCallusItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public Component m_7626_(ItemStack pStack) {
        return LangUtil.replaceInKey(() -> this.getPlant(pStack).getName(), "{plant}", "item.JurassicReborn.plant_callus");
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Direction side = context.m_43719_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (side == Direction.UP && world.m_8055_(pos.m_121945_(side)).m_60795_() && world.m_8055_(pos).m_60734_() == Blocks.f_50093_) {
            PlantDNA dna = PlantDNA.fromStack(stack);
            if (dna == null) {
                return InteractionResult.FAIL;
            }
            Plant plant = PlantHandler.getPlantById(dna.getPlant());
            if (plant != null) {
                Block block = plant.getBlock();
                if (!(block instanceof CropBlock) && !(block instanceof AncientCrop)) {
                    world.m_7731_(pos, Blocks.f_50493_.m_49966_(), 3);
                }
                if (block instanceof DoublePlantBlock) {
                    world.m_7731_(pos.m_7494_(), (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER), 3);
                    world.m_7731_(pos.m_6630_(2), (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 3);
                } else {
                    world.m_7731_(pos.m_7494_(), block.m_49966_(), 3);
                }
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Plant getPlant(ItemStack stack) {
        PlantDNA dna = PlantDNA.fromStack(stack);
        if (dna == null) {
            return PlantHandler.EMPTY;
        }
        return PlantHandler.getPlantById(dna.getPlant());
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
        if (pCategory != TabHandler.PLANTS && pCategory != CreativeModeTab.f_40754_) {
            return;
        }
        for (Plant p : PlantHandler.getPrehistoricPlantsAndTrees()) {
            PlantDNA dna = new PlantDNA(p.getId(), 100);
            CompoundTag plantData = new CompoundTag();
            dna.writeToNBT(plantData);
            ItemStack plant = ((PlantCallusItem)((Object)ModItems.PLANT_CALLUS.get())).m_7968_();
            plant.m_41751_(plantData);
            pItems.add((Object)plant);
        }
    }

    public ItemStack m_7968_() {
        ItemStack callus = new ItemStack((ItemLike)this);
        CompoundTag plantData = new CompoundTag();
        PlantDNA plantDNA = new PlantDNA(PlantHandler.EMPTY.getId(), 0);
        plantDNA.writeToNBT(plantData);
        callus.m_41751_(plantData);
        return callus;
    }

    public ItemStack getPlantInstance(PlantDNA dna) {
        ItemStack plant = ((PlantCallusItem)((Object)ModItems.PLANT_CALLUS.get())).m_7968_();
        CompoundTag plantData = new CompoundTag();
        dna.writeToNBT(plantData);
        plant.m_41751_(plantData);
        return plant;
    }

    public ItemStack getPlantInstance(Plant p, int quality) {
        return this.getPlantInstance(new PlantDNA(p.getId(), quality));
    }
}

