/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.recipes;

import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.common.items.ModItems;

public class PotionDartRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<PotionDartRecipe> SERIALIZER = new SimpleRecipeSerializer(PotionDartRecipe::new);

    public PotionDartRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack potion = ItemStack.f_41583_;
        int dartCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isPotion(stack)) {
                if (!potion.m_41619_()) {
                    return false;
                }
                potion = stack;
                continue;
            }
            if (stack.m_150930_((Item)ModItems.DART_TIPPED_POTION.get())) {
                ++dartCount;
                continue;
            }
            return false;
        }
        return !potion.m_41619_() && dartCount > 0;
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack potion = ItemStack.f_41583_;
        int dartCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isPotion(stack)) {
                if (!potion.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                potion = stack.m_41777_();
                continue;
            }
            if (stack.m_150930_((Item)ModItems.DART_TIPPED_POTION.get())) {
                ++dartCount;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (potion.m_41619_() || dartCount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)ModItems.DART_TIPPED_POTION.get(), dartCount);
        PotionUtils.m_43549_((ItemStack)result, (Potion)PotionUtils.m_43579_((ItemStack)potion));
        PotionUtils.m_43552_((ItemStack)result, (Collection)PotionUtils.m_43571_((ItemStack)potion));
        CompoundTag tag = potion.m_41783_();
        if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
            result.m_41784_().m_128405_("CustomPotionColor", tag.m_128451_("CustomPotionColor"));
        }
        return result;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)ModItems.DART_TIPPED_POTION.get());
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    private boolean isPotion(ItemStack stack) {
        return stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_);
    }
}

