/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.structure;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class StructureUtils {
    private static final String DATA_ID = "jurassicreborn_structure_info";

    @Nonnull
    public static StructureData getStructureData() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129783_();
        return (StructureData)level.m_8895_().m_164861_(StructureData::load, StructureData::new, DATA_ID);
    }

    public static class StructureData
    extends SavedData {
        private boolean visitorCenter = true;
        private boolean islaSornaLab = true;
        private boolean jpSanDiego = true;
        private boolean raptorPaddock = true;
        private boolean iceFossilDigsite = true;
        private boolean desertDigsite = true;
        private boolean amberMine = true;
        private boolean abandonedPaddock = true;
        private BlockPos visitorCenterPosition = BlockPos.f_121853_;
        private BlockPos islaSornaLabPosition = BlockPos.f_121853_;
        private BlockPos jpSanDiegoPosition = BlockPos.f_121853_;

        public StructureData() {
        }

        public StructureData(String id) {
        }

        public static StructureData load(CompoundTag tag) {
            StructureData data = new StructureData();
            data.read(tag);
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128379_("VisitorCenter", this.visitorCenter);
            tag.m_128379_("IslaSornaLab", this.islaSornaLab);
            tag.m_128379_("JPSanDiego", this.jpSanDiego);
            tag.m_128379_("RaptorPaddock", this.raptorPaddock);
            tag.m_128379_("AbandonedPaddock", this.abandonedPaddock);
            tag.m_128379_("IceFossilDigsite", this.iceFossilDigsite);
            tag.m_128379_("DesertDigsite", this.desertDigsite);
            tag.m_128379_("AmberMine", this.amberMine);
            tag.m_128356_("VisitorCenterBlockPosition", this.visitorCenterPosition.m_121878_());
            tag.m_128356_("IslaSornaLabBlockPosition", this.islaSornaLabPosition.m_121878_());
            tag.m_128356_("SanDiegoBlockPosition", this.jpSanDiegoPosition.m_121878_());
            return tag;
        }

        public void read(CompoundTag tag) {
            this.visitorCenter = tag.m_128471_("VisitorCenter");
            this.islaSornaLab = tag.m_128471_("IslaSornaLab");
            this.jpSanDiego = tag.m_128471_("JPSanDiego");
            this.raptorPaddock = tag.m_128471_("RaptorPaddock");
            this.abandonedPaddock = tag.m_128471_("AbandonedPaddock");
            this.iceFossilDigsite = tag.m_128471_("IceFossilDigsite");
            this.desertDigsite = tag.m_128471_("DesertDigsite");
            this.amberMine = tag.m_128471_("AmberMine");
            this.visitorCenterPosition = BlockPos.m_122022_((long)tag.m_128454_("VisitorCenterBlockPosition"));
            this.islaSornaLabPosition = BlockPos.m_122022_((long)tag.m_128454_("IslaSornaLabBlockPosition"));
            this.jpSanDiegoPosition = BlockPos.m_122022_((long)tag.m_128454_("SanDiegoBlockPosition"));
        }

        public boolean isVisitorCenter() {
            return this.visitorCenter;
        }

        public boolean isIslaSornaLab() {
            return this.islaSornaLab;
        }

        public boolean isJPSanDiego() {
            return this.jpSanDiego;
        }

        public boolean isRaptorPaddock() {
            return this.raptorPaddock;
        }

        public boolean isAbandonedPaddock() {
            return this.abandonedPaddock;
        }

        public boolean isIceFossilDigsite() {
            return this.iceFossilDigsite;
        }

        public boolean isDesertDigsite() {
            return this.desertDigsite;
        }

        public boolean isAmberMine() {
            return this.amberMine;
        }

        public BlockPos getVisitorCenterPosition() {
            return this.visitorCenterPosition;
        }

        public BlockPos getIslaSornaLabPosition() {
            return this.islaSornaLabPosition;
        }

        public BlockPos getJPSanDiegoPosition() {
            return this.jpSanDiegoPosition;
        }

        public void setIslaSornaLabPosition(BlockPos pos) {
            this.islaSornaLabPosition = pos;
            this.m_77762_();
        }

        public void setJPSanDiegoPosition(BlockPos pos) {
            this.jpSanDiegoPosition = pos;
            this.m_77762_();
        }

        public void setVisitorCenterPosition(BlockPos pos) {
            this.visitorCenterPosition = pos;
            this.m_77762_();
        }
    }
}

