/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.vit.jurassicreborn.common.blocks.wood.AncientLeavesBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.worldgen.tree.BaseTreeGenerator;
import net.vit.jurassicreborn.common.worldgen.tree.TreePlaceUtil;

public class PhoenixTreeGenerator
extends Feature<NoneFeatureConfiguration> {
    public PhoenixTreeGenerator(Codec<NoneFeatureConfiguration> p_65786_) {
        super(p_65786_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockState log = ((RotatedPillarBlock)WoodBlocks.PHOENIX_LOG.get()).m_49966_();
        BlockState leaves = (BlockState)((Block)WoodBlocks.PHOENIX_LEAVES.get()).m_49966_().m_61124_((Property)AncientLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1));
        WorldGenLevel world = ctx.m_159774_();
        RandomSource rand = ctx.m_225041_();
        BlockPos position = ctx.m_159777_();
        int height = rand.m_188503_(6) + 7;
        if (!this.canPlace(ctx, height, height)) {
            return false;
        }
        world.m_7731_(position, log, 19);
        for (int y = 0; y < height; ++y) {
            BaseTreeGenerator.setBlockState(world, position.m_6630_(y), log);
        }
        for (int palmX = -1; palmX < 2; ++palmX) {
            for (int palmY = -1; palmY < 1; ++palmY) {
                for (int palmZ = -1; palmZ < 2; ++palmZ) {
                    BaseTreeGenerator.setBlockState(world, position.m_7918_(palmX, height + 1 + palmY, palmZ), leaves);
                }
            }
        }
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height + 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height + 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height + 4), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(1, height + 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-1, height + 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 2, 1), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 2, -1), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height + 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height + 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 2, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 2, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height + 3, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height + 3, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-4, height + 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height + 3, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height + 3, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(4, height + 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 3, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 3, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 2, 4), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 3, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 3, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height + 2, -4), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height - 1, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height - 1, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height - 1, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height - 1, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height - 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height - 2, 0), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height - 2, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height - 2, -3), leaves);
        if (rand.m_188499_()) {
            BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height - 3, 0), leaves);
            BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height - 3, 0), leaves);
            BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height - 3, 3), leaves);
            BaseTreeGenerator.setBlockState(world, position.m_7918_(0, height - 3, -3), leaves);
        }
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height + 1, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height + 2, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height + 1, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height + 2, 2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height + 1, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(2, height + 2, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height + 1, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-2, height + 2, -2), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height - 1, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height + 1, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height - 1, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height + 1, 3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height - 1, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(3, height + 1, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height - 1, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height, -3), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_7918_(-3, height + 1, -3), leaves);
        return true;
    }

    private boolean canPlace(FeaturePlaceContext<NoneFeatureConfiguration> pContext, int height, int branchHeight) {
        BlockPos.MutableBlockPos min = pContext.m_159777_().m_122032_();
        min.m_122184_(-4, branchHeight, -4);
        BlockPos.MutableBlockPos max = pContext.m_159777_().m_122032_();
        max.m_122184_(4, height + 4, 4);
        for (int y = 0; y < branchHeight; ++y) {
            if (TreePlaceUtil.validTreePos(pContext.m_159774_(), pContext.m_159777_().m_6630_(y))) continue;
            return false;
        }
        for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y < max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                    if (TreePlaceUtil.validTreePos(pContext.m_159774_(), new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

