/*
 * Decompiled with CFR 0.152.
 */
package org.eu.awesomekalin.pufferfishapi.registry;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.eu.awesomekalin.pufferfishapi.PufferfishAPI;
import org.eu.awesomekalin.pufferfishapi.holders.ArmorHolder;
import org.eu.awesomekalin.pufferfishapi.holders.ItemRegistryHolder;
import org.eu.awesomekalin.pufferfishapi.holders.MobEffectHolder;
import org.eu.awesomekalin.pufferfishapi.holders.SoundEventsHolder;
import org.eu.awesomekalin.pufferfishapi.holders.ToolHolder;

public class ItemRegistry {
    private final DeferredRegister.Items register;
    private final String modId;

    public ItemRegistry(String modId) {
        this.register = DeferredRegister.createItems((String)modId);
        this.modId = modId;
    }

    public void register() {
        this.register.register(PufferfishAPI.eventBus);
    }

    private ToolMaterial getToolMaterial(ToolHolder toolHolder) {
        return new ToolMaterial(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)toolHolder.material.incorrectForBlocksTag.namespace, (String)toolHolder.material.incorrectForBlocksTag.path)), toolHolder.material.durability, toolHolder.material.speed, toolHolder.material.attackDamageBonus, toolHolder.material.enchantValue, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)toolHolder.material.repairTag.namespace, (String)toolHolder.material.repairTag.path)));
    }

    private ArmorMaterial getArmorMaterial(ArmorHolder armorHolder) {
        return new ArmorMaterial(armorHolder.durability, armorHolder.defense, armorHolder.enchantmentValue, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEventsHolder.getSoundEvent(armorHolder.equipSound)), armorHolder.toughness, armorHolder.knockbackResistance, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)armorHolder.repairIngredient.namespace, (String)armorHolder.repairIngredient.path)), armorHolder.assetId);
    }

    private Item.Properties addIdToProperties(String name, Item.Properties properties) {
        return properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name)));
    }

    public ItemRegistryHolder registerSword(ToolHolder toolHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(toolHolder.name, () -> new Item(this.addIdToProperties(toolHolder.name, new Item.Properties().sword(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed)))));
    }

    public ItemRegistryHolder registerPickaxe(ToolHolder toolHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(toolHolder.name, () -> new Item(this.addIdToProperties(toolHolder.name, new Item.Properties().pickaxe(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed)))));
    }

    public ItemRegistryHolder registerAxe(ToolHolder toolHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(toolHolder.name, () -> new Item(this.addIdToProperties(toolHolder.name, new Item.Properties().axe(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed)))));
    }

    public ItemRegistryHolder registerShovel(ToolHolder toolHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(toolHolder.name, () -> new Item(this.addIdToProperties(toolHolder.name, new Item.Properties().shovel(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed)))));
    }

    public ItemRegistryHolder registerHoe(ToolHolder toolHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(toolHolder.name, () -> new Item(this.addIdToProperties(toolHolder.name, new Item.Properties().hoe(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed)))));
    }

    public ItemRegistryHolder registerFoodWithEffects(String name, int nutrition, float saturation, boolean alwaysEat, List<MobEffectHolder> effects) {
        Consumable.Builder builder = Consumable.builder();
        effects.forEach(effect -> builder.onConsume((ConsumeEffect)effect.getEffectFromEnum()));
        Item.Properties itemProperties = this.addIdToProperties(name, new Item.Properties().food(new FoodProperties(nutrition, saturation, alwaysEat)).component(DataComponents.CONSUMABLE, (Object)builder.build()));
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.registerSimpleItem(name, itemProperties));
    }

    public ItemRegistryHolder registerHelmet(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(name, () -> new Item(this.addIdToProperties(name, new Item.Properties().humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.HELMET)))));
    }

    public ItemRegistryHolder registerChestplate(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(name, () -> new Item(this.addIdToProperties(name, new Item.Properties().humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.CHESTPLATE)))));
    }

    public ItemRegistryHolder registerLeggings(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(name, () -> new Item(this.addIdToProperties(name, new Item.Properties().humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.LEGGINGS)))));
    }

    public ItemRegistryHolder registerBoots(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((DeferredItem<Item>)this.register.register(name, () -> new Item(this.addIdToProperties(name, new Item.Properties().humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.BOOTS)))));
    }
}

