/*
 * Decompiled with CFR 0.152.
 */
package org.eu.awesomekalin.pufferfishapi.registry;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.eu.awesomekalin.pufferfishapi.PufferfishAPI;
import org.eu.awesomekalin.pufferfishapi.holders.ArmorHolder;
import org.eu.awesomekalin.pufferfishapi.holders.ItemRegistryHolder;
import org.eu.awesomekalin.pufferfishapi.holders.MobEffectHolder;
import org.eu.awesomekalin.pufferfishapi.holders.SoundEventsHolder;
import org.eu.awesomekalin.pufferfishapi.holders.ToolHolder;

public class ItemRegistry {
    private final DeferredRegister<Item> register;
    private final String modId;

    public ItemRegistry(String modId) {
        this.register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modId);
        this.modId = modId;
    }

    public void register() {
        this.register.register(PufferfishAPI.context.getModBusGroup());
    }

    private ToolMaterial getToolMaterial(ToolHolder toolHolder) {
        return new ToolMaterial(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)toolHolder.material.incorrectForBlocksTag.namespace, (String)toolHolder.material.incorrectForBlocksTag.path)), toolHolder.material.durability, toolHolder.material.speed, toolHolder.material.attackDamageBonus, toolHolder.material.enchantValue, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)toolHolder.material.repairTag.namespace, (String)toolHolder.material.repairTag.path)));
    }

    private ArmorMaterial getArmorMaterial(ArmorHolder armorHolder) {
        return new ArmorMaterial(armorHolder.durability, armorHolder.defense, armorHolder.enchantmentValue, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEventsHolder.getSoundEvent(armorHolder.equipSound)), armorHolder.toughness, armorHolder.knockbackResistance, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)armorHolder.repairIngredient.namespace, (String)armorHolder.repairIngredient.path)), armorHolder.assetId);
    }

    private Item.Properties getBasicProperties(String name) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name)));
    }

    public ItemRegistryHolder registerSword(ToolHolder toolHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(toolHolder.name, () -> new Item(this.getBasicProperties(toolHolder.name).sword(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed))));
    }

    public ItemRegistryHolder registerPickaxe(ToolHolder toolHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(toolHolder.name, () -> new Item(this.getBasicProperties(toolHolder.name).pickaxe(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed))));
    }

    public ItemRegistryHolder registerAxe(ToolHolder toolHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(toolHolder.name, () -> new AxeItem(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackSpeed, this.getBasicProperties(toolHolder.name))));
    }

    public ItemRegistryHolder registerShovel(ToolHolder toolHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(toolHolder.name, () -> new ShovelItem(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackDamage, this.getBasicProperties(toolHolder.name))));
    }

    public ItemRegistryHolder registerHoe(ToolHolder toolHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(toolHolder.name, () -> new HoeItem(this.getToolMaterial(toolHolder), toolHolder.attackDamage, toolHolder.attackDamage, this.getBasicProperties(toolHolder.name))));
    }

    public ItemRegistryHolder registerFoodWithEffects(String name, int nutrition, float saturation, boolean alwaysEat, List<MobEffectHolder> effects) {
        Consumable.Builder builder = Consumable.builder();
        effects.forEach(effect -> builder.onConsume((ConsumeEffect)effect.getEffectFromEnum()));
        Item.Properties itemProperties = this.getBasicProperties(name).food(new FoodProperties(nutrition, saturation, alwaysEat)).component(DataComponents.CONSUMABLE, (Object)builder.build());
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(name, () -> new Item(itemProperties)));
    }

    public ItemRegistryHolder registerHelmet(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(name, () -> new Item(this.getBasicProperties(name).humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.HELMET).durability(ArmorType.HELMET.getDurability(armorHolder.durability)))));
    }

    public ItemRegistryHolder registerChestplate(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(name, () -> new Item(this.getBasicProperties(name).humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.CHESTPLATE).durability(ArmorType.CHESTPLATE.getDurability(armorHolder.durability)))));
    }

    public ItemRegistryHolder registerLeggings(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(name, () -> new Item(this.getBasicProperties(name).humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.LEGGINGS).durability(ArmorType.LEGGINGS.getDurability(armorHolder.durability)))));
    }

    public ItemRegistryHolder registerBoots(String name, ArmorHolder armorHolder) {
        return new ItemRegistryHolder((RegistryObject<Item>)this.register.register(name, () -> new Item(this.getBasicProperties(name).humanoidArmor(this.getArmorMaterial(armorHolder), ArmorType.BOOTS).durability(ArmorType.BOOTS.getDurability(armorHolder.durability)))));
    }
}

