/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import org.texboobcat.catQueue.commands.QueueAdminCommand;
import org.texboobcat.catQueue.commands.QueueCommand;
import org.texboobcat.catQueue.commands.QueueMusicCommand;
import org.texboobcat.catQueue.commands.QueueMuteCommand;
import org.texboobcat.catQueue.commands.QueueSkipCommand;
import org.texboobcat.catQueue.commands.QueueTopCommand;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.integrations.DiscordNotifier;
import org.texboobcat.catQueue.listeners.ConnectListener;
import org.texboobcat.catQueue.listeners.QueueListener;
import org.texboobcat.catQueue.persistence.PersistenceManager;
import org.texboobcat.catQueue.services.AnalyticsService;
import org.texboobcat.catQueue.services.AutoscalerService;
import org.texboobcat.catQueue.services.CapacityService;
import org.texboobcat.catQueue.services.LeaderboardService;
import org.texboobcat.catQueue.services.MusicService;
import org.texboobcat.catQueue.services.RewardService;
import org.texboobcat.catQueue.services.TimeoutService;
import org.texboobcat.catQueue.util.MessageUtil;

@Plugin(id="catqueue", name="CatQueue", version="1.0-SNAPSHOT")
public class CatQueue {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private ConfigManager configManager;
    private QueueManager queueManager;
    private PersistenceManager persistenceManager;
    private TimeoutService timeoutService;
    private RewardService rewardService;
    private LeaderboardService leaderboardService;
    private DiscordNotifier discordNotifier;
    private CapacityService capacityService;
    private AnalyticsService analyticsService;
    private int infoMsgIndex = 0;
    private MusicService musicService;
    private AutoscalerService autoscalerService;

    @Inject
    public CatQueue(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        ArrayList<String> msgs;
        this.configManager = new ConfigManager(this.logger, this.dataDirectory);
        this.configManager.load();
        this.queueManager = new QueueManager(this.logger, this.configManager);
        this.persistenceManager = new PersistenceManager(this.logger, this.dataDirectory);
        this.rewardService = new RewardService(this.logger, this.server, this.configManager);
        this.leaderboardService = new LeaderboardService(this.logger);
        this.discordNotifier = new DiscordNotifier(this.logger, this.configManager.discordWebhookUrl());
        this.capacityService = new CapacityService(this.configManager, this.server);
        this.analyticsService = new AnalyticsService(this.logger, this.configManager);
        if (this.configManager.dbEnabled()) {
            this.analyticsService.init();
        }
        this.musicService = new MusicService(this.logger, this.server, this.configManager, this.queueManager, this.dataDirectory);
        this.autoscalerService = new AutoscalerService(this.logger, this.configManager, this.server, this.capacityService);
        for (PersistenceManager.Record rec : this.persistenceManager.load()) {
            this.queueManager.enqueueRestored(rec.uuid(), rec.priority(), rec.joinedAt());
        }
        try {
            Map<UUID, Long> lb = this.persistenceManager.loadLeaderboard();
            this.leaderboardService.replaceAll(lb);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to load leaderboard: {}", (Object)ex.toString());
        }
        this.server.getEventManager().register((Object)this, (Object)new QueueListener(this.queueManager, this.logger, this.configManager, this.discordNotifier));
        this.server.getEventManager().register((Object)this, (Object)new ConnectListener(this.queueManager, this.configManager, this.logger, this.server, this.rewardService, this.leaderboardService, this.discordNotifier, this.capacityService, this.analyticsService));
        CommandManager cm = this.server.getCommandManager();
        CommandMeta queueMeta = cm.metaBuilder("queue").build();
        cm.register(queueMeta, (Command)new QueueCommand(this.queueManager, this.configManager));
        CommandMeta adminMeta = cm.metaBuilder("queueadmin").build();
        cm.register(adminMeta, (Command)new QueueAdminCommand(this.queueManager, this.server, this.logger, this.capacityService).withConfig(this.configManager));
        CommandMeta topMeta = cm.metaBuilder("queuetop").build();
        cm.register(topMeta, (Command)new QueueTopCommand(this.server, this.leaderboardService));
        CommandMeta skipMeta = cm.metaBuilder("queueskip").build();
        cm.register(skipMeta, (Command)new QueueSkipCommand(this.queueManager, this.configManager, this.discordNotifier));
        CommandMeta muteMeta = cm.metaBuilder("queuemute").build();
        cm.register(muteMeta, (Command)new QueueMuteCommand(this.musicService));
        CommandMeta musicMeta = cm.metaBuilder("queuemusic").build();
        cm.register(musicMeta, (Command)new QueueMusicCommand(this.musicService));
        this.server.getScheduler().buildTask((Object)this, () -> {
            for (UUID uuid : this.queueManager.listQueued()) {
                this.server.getPlayer(uuid).ifPresent(player -> {
                    int pos = this.queueManager.getPosition(uuid);
                    Duration eta = this.queueManager.estimateWait(uuid, this.configManager.slotsPerMinute(), this.configManager.pteroUtilizationTargetServer());
                    HashMap<String, String> ph = new HashMap<String, String>();
                    ph.put("position", String.valueOf(pos));
                    ph.put("eta", MessageUtil.humanize(eta));
                    Object msg = MessageUtil.apply(this.configManager.msgUpdate(), ph);
                    List<String> infos = this.configManager.infoMessages();
                    if (!infos.isEmpty()) {
                        String extra = infos.get((int)(Math.random() * (double)infos.size()));
                        msg = (String)msg + " \u00a77| " + extra;
                    }
                    player.sendMessage((Component)Component.text((String)msg));
                });
            }
        }).repeat(Duration.ofMillis((long)this.configManager.notifyIntervalTicks() * 50L)).schedule();
        if (this.configManager.actionBarEnabled()) {
            this.server.getScheduler().buildTask((Object)this, () -> {
                for (UUID uuid : this.queueManager.listQueued()) {
                    this.server.getPlayer(uuid).ifPresent(player -> {
                        int pos = this.queueManager.getPosition(uuid);
                        Duration eta = this.queueManager.estimateWait(uuid, this.configManager.slotsPerMinute(), this.configManager.pteroUtilizationTargetServer());
                        HashMap<String, String> ph = new HashMap<String, String>();
                        ph.put("position", String.valueOf(pos));
                        ph.put("eta", MessageUtil.humanize(eta));
                        String bar = MessageUtil.apply(this.configManager.msgActionBar(), ph);
                        player.sendActionBar((Component)Component.text((String)bar));
                    });
                }
            }).repeat(Duration.ofMillis((long)Math.max(1, this.configManager.actionBarIntervalTicks()) * 50L)).schedule();
        }
        if (this.configManager.infoEnabled() && !(msgs = new ArrayList<String>(new LinkedList<String>(this.configManager.infoMessages()))).isEmpty()) {
            this.server.getScheduler().buildTask((Object)this, () -> {
                if (msgs.isEmpty()) {
                    return;
                }
                String next = (String)msgs.get(this.infoMsgIndex % msgs.size());
                ++this.infoMsgIndex;
                for (UUID uuid : this.queueManager.listQueued()) {
                    this.server.getPlayer(uuid).ifPresent(p -> p.sendMessage((Component)Component.text((String)next)));
                }
            }).repeat(Duration.ofMillis((long)Math.max(1, this.configManager.infoIntervalTicks()) * 50L)).schedule();
        }
        if (this.configManager.musicEnabled()) {
            this.server.getScheduler().buildTask((Object)this, () -> this.musicService.playTick()).repeat(Duration.ofMillis(50L)).schedule();
        }
        this.timeoutService = new TimeoutService(this.queueManager, this.configManager, this.server, this.logger, this.discordNotifier);
        this.server.getScheduler().buildTask((Object)this, this.timeoutService::tick).repeat(Duration.ofSeconds(5L)).schedule();
        if (this.configManager.pteroEnabled()) {
            this.server.getScheduler().buildTask((Object)this, () -> this.autoscalerService.tick()).repeat(Duration.ofSeconds(30L)).schedule();
            this.logger.info("Pterodactyl autoscaler enabled{}.", (Object)(this.configManager.pteroDryRun() ? " (dry-run)" : ""));
        }
        this.server.getScheduler().buildTask((Object)this, () -> {
            int affected = this.queueManager.applyPriorityDecay();
            if (affected > 0) {
                this.logger.debug("Priority decay applied to {} players.", (Object)affected);
            }
            this.queueManager.cleanupGrace();
        }).repeat(Duration.ofMinutes(1L)).schedule();
        this.server.getScheduler().buildTask((Object)this, () -> {
            try {
                this.persistenceManager.save(this.queueManager);
                this.persistenceManager.saveLeaderboard(this.leaderboardService.snapshot());
            }
            catch (Exception ex) {
                this.logger.warn("Autosave failed: {}", (Object)ex.toString());
            }
        }).repeat(Duration.ofSeconds(60L)).schedule();
        if (this.configManager.featureDiscord()) {
            this.server.getScheduler().buildTask((Object)this, () -> {
                try {
                    int size = this.queueManager.size();
                    this.discordNotifier.send("Queue status: size=" + size);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).repeat(Duration.ofSeconds(120L)).schedule();
        }
        this.logger.info("CatQueue initialized. Version {}", (Object)"1.0-SNAPSHOT");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.persistenceManager != null) {
            this.persistenceManager.save(this.queueManager);
            try {
                this.persistenceManager.saveLeaderboard(this.leaderboardService.snapshot());
            }
            catch (Exception ex) {
                this.logger.warn("Failed to save leaderboard on shutdown: {}", (Object)ex.toString());
            }
        }
        if (this.analyticsService != null) {
            try {
                this.analyticsService.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

