/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.commands;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.services.CapacityService;

public class QueueAdminCommand
implements SimpleCommand {
    private final QueueManager queueManager;
    private final ProxyServer server;
    private final Logger logger;
    private final CapacityService capacityService;
    private ConfigManager configManager;

    public QueueAdminCommand(QueueManager queueManager, ProxyServer server, Logger logger, CapacityService capacityService) {
        this.queueManager = queueManager;
        this.server = server;
        this.logger = logger;
        this.capacityService = capacityService;
    }

    public QueueAdminCommand withConfig(ConfigManager cfg) {
        this.configManager = cfg;
        return this;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin <size|clear|next|remove <player>|cap <server>|setcap <server> <n>|clearcap <server>|reprioritize <permission> <delta>>"));
            return;
        }
        block22 : switch (args[0].toLowerCase()) {
            case "size": {
                invocation.source().sendMessage((Component)Component.text((String)("Queue size: " + this.queueManager.size())));
                break;
            }
            case "clear": {
                for (UUID uuid : this.queueManager.listQueued()) {
                    this.queueManager.remove(uuid);
                }
                invocation.source().sendMessage((Component)Component.text((String)"Queue cleared."));
                this.logger.info("QueueAdmin: cleared queue by {}", (Object)invocation.source());
                break;
            }
            case "next": {
                Optional<UUID> next = this.queueManager.pollNext();
                invocation.source().sendMessage((Component)Component.text((String)("Dequeued: " + next.map(UUID::toString).orElse("none"))));
                this.logger.info("QueueAdmin: polled next -> {} by {}", (Object)next.map(UUID::toString).orElse("none"), (Object)invocation.source());
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin remove <player>"));
                    return;
                }
                String name = args[1];
                Optional opt = this.server.getPlayer(name);
                if (opt.isEmpty()) {
                    invocation.source().sendMessage((Component)Component.text((String)("Player not online: " + name)));
                    return;
                }
                boolean removed = this.queueManager.remove(((Player)opt.get()).getUniqueId());
                invocation.source().sendMessage((Component)Component.text((String)(removed ? "Removed from queue." : "Player not in queue.")));
                this.logger.info("QueueAdmin: remove {} -> {} by {}", new Object[]{name, removed, invocation.source()});
                break;
            }
            case "cap": {
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin cap <server>"));
                    return;
                }
                String serverName = args[1];
                int cap = this.capacityService.getCapacity(serverName);
                invocation.source().sendMessage((Component)Component.text((String)("Capacity for " + serverName + ": " + cap)));
                break;
            }
            case "setcap": {
                if (args.length < 3) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin setcap <server> <capacity>"));
                    return;
                }
                String serverName = args[1];
                try {
                    int cap = Integer.parseInt(args[2]);
                    this.capacityService.setOverride(serverName, cap);
                    invocation.source().sendMessage((Component)Component.text((String)("Set capacity for " + serverName + " to " + cap)));
                    this.logger.info("QueueAdmin: setcap {} -> {} by {}", new Object[]{serverName, cap, invocation.source()});
                }
                catch (NumberFormatException e) {
                    invocation.source().sendMessage((Component)Component.text((String)"Capacity must be a number."));
                }
                break;
            }
            case "clearcap": {
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin clearcap <server>"));
                    return;
                }
                String serverName = args[1];
                this.capacityService.clearOverride(serverName);
                invocation.source().sendMessage((Component)Component.text((String)("Cleared capacity override for " + serverName)));
                this.logger.info("QueueAdmin: clearcap {} by {}", (Object)serverName, (Object)invocation.source());
                break;
            }
            case "reprioritize": {
                int delta;
                if (args.length < 3) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin reprioritize <permission> <delta>"));
                    return;
                }
                String perm = args[1];
                try {
                    delta = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException ex) {
                    invocation.source().sendMessage((Component)Component.text((String)"Delta must be a number."));
                    return;
                }
                int affected = 0;
                for (UUID uuid : this.queueManager.listQueued()) {
                    Optional opt = this.server.getPlayer(uuid);
                    if (!opt.isPresent() || !((Player)opt.get()).hasPermission(perm) || !this.queueManager.promote(uuid, delta)) continue;
                    ++affected;
                }
                invocation.source().sendMessage((Component)Component.text((String)("Reprioritized " + affected + " players with permission '" + perm + "' by +" + delta)));
                this.logger.info("QueueAdmin: reprioritize perm={} delta={} affected={} by {}", new Object[]{perm, delta, affected, invocation.source()});
                break;
            }
            case "decay": {
                if (this.configManager == null) {
                    invocation.source().sendMessage((Component)Component.text((String)"Config not available."));
                    return;
                }
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin decay <show|enable <true|false>|minutes <n>|amount <n>|min <n>>"));
                    return;
                }
                switch (args[1].toLowerCase()) {
                    case "show": {
                        invocation.source().sendMessage((Component)Component.text((String)("Decay: enabled=" + this.configManager.decayEnabled() + ", minutesPerStep=" + this.configManager.decayMinutesPerStep() + ", amountPerStep=" + this.configManager.decayAmountPerStep() + ", minPriority=" + this.configManager.decayMinPriority())));
                        break block22;
                    }
                    case "enable": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin decay enable <true|false>"));
                            return;
                        }
                        boolean v = Boolean.parseBoolean(args[2]);
                        this.configManager.setDecayEnabledOverride(v);
                        invocation.source().sendMessage((Component)Component.text((String)("Decay enabled set to " + v)));
                        break block22;
                    }
                    case "minutes": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin decay minutes <n>"));
                            return;
                        }
                        try {
                            int v = Integer.parseInt(args[2]);
                            this.configManager.setDecayMinutesPerStepOverride(v);
                            invocation.source().sendMessage((Component)Component.text((String)("Decay minutesPerStep set to " + v)));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"Must be a number."));
                        }
                        break block22;
                    }
                    case "amount": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin decay amount <n>"));
                            return;
                        }
                        try {
                            int v = Integer.parseInt(args[2]);
                            this.configManager.setDecayAmountPerStepOverride(v);
                            invocation.source().sendMessage((Component)Component.text((String)("Decay amountPerStep set to " + v)));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"Must be a number."));
                        }
                        break block22;
                    }
                    case "min": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin decay min <n>"));
                            return;
                        }
                        try {
                            int v = Integer.parseInt(args[2]);
                            this.configManager.setDecayMinPriorityOverride(v);
                            invocation.source().sendMessage((Component)Component.text((String)("Decay minPriority set to " + v)));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"Must be a number."));
                        }
                        break block22;
                    }
                }
                invocation.source().sendMessage((Component)Component.text((String)"Unknown decay subcommand."));
                break;
            }
            case "grace": {
                if (this.configManager == null) {
                    invocation.source().sendMessage((Component)Component.text((String)"Config not available."));
                    return;
                }
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin grace <show|set <minutes>>"));
                    return;
                }
                switch (args[1].toLowerCase()) {
                    case "show": {
                        invocation.source().sendMessage((Component)Component.text((String)("Grace minutes: " + this.configManager.getGraceMinutesEffective())));
                        break block22;
                    }
                    case "set": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin grace set <minutes>"));
                            return;
                        }
                        try {
                            int v = Integer.parseInt(args[2]);
                            this.configManager.setGraceMinutesOverride(v);
                            invocation.source().sendMessage((Component)Component.text((String)("Grace minutes set to " + v)));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"Must be a number."));
                        }
                        break block22;
                    }
                }
                invocation.source().sendMessage((Component)Component.text((String)"Unknown grace subcommand."));
                break;
            }
            case "autoscaler": {
                if (this.configManager == null) {
                    invocation.source().sendMessage((Component)Component.text((String)"Config not available."));
                    return;
                }
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queueadmin autoscaler <status|enable <true|false>|dryrun <true|false>|thresholds <queueDepth> <util%> <downUtil%> <downQueueMax>|cooldowns <upSec> <downSec>|buffer <slots> <seconds>|target <server>>"));
                    return;
                }
                switch (args[1].toLowerCase()) {
                    case "status": {
                        String msg = String.format("Ptero: enabled=%s dryRun=%s target=%s thresholds[q=%d,up%%=%d,down%%=%d,downQMax=%d] cooldowns[up=%ds,down=%ds] buffer[slots=%d,sec=%d]", this.configManager.pteroEnabled(), this.configManager.pteroDryRun(), this.configManager.pteroUtilizationTargetServer(), this.configManager.pteroQueueDepthThreshold(), this.configManager.pteroUtilizationPercentThreshold(), this.configManager.pteroDownUtilizationPercentThreshold(), this.configManager.pteroDownQueueDepthMax(), this.configManager.pteroCooldownUpSeconds(), this.configManager.pteroCooldownDownSeconds(), this.configManager.pteroBootBufferSlots(), this.configManager.pteroBootBufferSeconds());
                        invocation.source().sendMessage((Component)Component.text((String)msg));
                        break block22;
                    }
                    case "enable": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin autoscaler enable <true|false>"));
                            return;
                        }
                        boolean v = Boolean.parseBoolean(args[2]);
                        this.configManager.setPteroEnabledOverride(v);
                        invocation.source().sendMessage((Component)Component.text((String)("Pterodactyl autoscaler enabled set to " + v + ". Note: scheduler activation occurs at startup.")));
                        break block22;
                    }
                    case "dryrun": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin autoscaler dryrun <true|false>"));
                            return;
                        }
                        boolean v = Boolean.parseBoolean(args[2]);
                        this.configManager.setPteroDryRunOverride(v);
                        invocation.source().sendMessage((Component)Component.text((String)("Pterodactyl dryRun set to " + v)));
                        break block22;
                    }
                    case "thresholds": {
                        if (args.length < 6) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin autoscaler thresholds <queueDepth> <util%> <downUtil%> <downQueueMax>"));
                            return;
                        }
                        try {
                            int q = Integer.parseInt(args[2]);
                            int up = Integer.parseInt(args[3]);
                            int down = Integer.parseInt(args[4]);
                            int dq = Integer.parseInt(args[5]);
                            this.configManager.setPteroQueueDepthThresholdOverride(q);
                            this.configManager.setPteroUtilizationPercentThresholdOverride(up);
                            this.configManager.setPteroDownUtilizationPercentThresholdOverride(down);
                            this.configManager.setPteroDownQueueDepthMaxOverride(dq);
                            invocation.source().sendMessage((Component)Component.text((String)"Updated thresholds."));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"All threshold values must be integers."));
                        }
                        break block22;
                    }
                    case "cooldowns": {
                        if (args.length < 4) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin autoscaler cooldowns <upSec> <downSec>"));
                            return;
                        }
                        try {
                            int up = Integer.parseInt(args[2]);
                            int down = Integer.parseInt(args[3]);
                            this.configManager.setPteroCooldownUpSecondsOverride(up);
                            this.configManager.setPteroCooldownDownSecondsOverride(down);
                            invocation.source().sendMessage((Component)Component.text((String)"Updated cooldowns."));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"Cooldown values must be integers."));
                        }
                        break block22;
                    }
                    case "buffer": {
                        if (args.length < 4) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin autoscaler buffer <slots> <seconds>"));
                            return;
                        }
                        try {
                            int slots = Integer.parseInt(args[2]);
                            int sec = Integer.parseInt(args[3]);
                            this.configManager.setPteroBootBufferSlotsOverride(slots);
                            this.configManager.setPteroBootBufferSecondsOverride(sec);
                            invocation.source().sendMessage((Component)Component.text((String)"Updated boot buffer."));
                        }
                        catch (NumberFormatException ex) {
                            invocation.source().sendMessage((Component)Component.text((String)"Buffer values must be integers."));
                        }
                        break block22;
                    }
                    case "target": {
                        if (args.length < 3) {
                            invocation.source().sendMessage((Component)Component.text((String)"/queueadmin autoscaler target <server>"));
                            return;
                        }
                        this.configManager.setPteroUtilizationTargetServerOverride(args[2]);
                        invocation.source().sendMessage((Component)Component.text((String)("Updated target server to " + args[2])));
                        break block22;
                    }
                }
                invocation.source().sendMessage((Component)Component.text((String)"Unknown autoscaler subcommand."));
                break;
            }
            default: {
                invocation.source().sendMessage((Component)Component.text((String)"Unknown subcommand."));
            }
        }
    }
}

