/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.time.Duration;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import org.texboobcat.catQueue.CatQueue;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.util.MessageUtil;

public class QueueCommand
implements SimpleCommand {
    private final QueueManager queueManager;
    private final ConfigManager config;

    public QueueCommand(QueueManager queueManager, ConfigManager config) {
        this.queueManager = queueManager;
        this.config = config;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage((Component)Component.text((String)"This command is for players."));
            return;
        }
        Player player = (Player)commandSource;
        String[] args = (String[])invocation.arguments();
        if (args.length > 0 && args[0].equalsIgnoreCase("skip")) {
            if (!this.config.priorityEnabled() || !player.hasPermission(this.config.vipPermission())) {
                player.sendMessage((Component)Component.text((String)"You don't have permission to skip."));
                return;
            }
            boolean ok = this.queueManager.promote(player.getUniqueId(), 1);
            int posNow = this.queueManager.getPosition(player.getUniqueId());
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("position", String.valueOf(posNow));
            String msg = MessageUtil.apply(this.config.msgPriorityJoin(), ph);
            player.sendMessage((Component)Component.text((String)msg));
            if (!ok) {
                player.sendMessage((Component)Component.text((String)"You are not in the queue."));
            }
            return;
        }
        if (!this.queueManager.isQueued(player.getUniqueId())) {
            player.sendMessage((Component)Component.text((String)"You are not in the queue."));
            return;
        }
        int pos = this.queueManager.getPosition(player.getUniqueId());
        int slotsPerMinute = this.config.slotsPerMinute();
        String targetName = CatQueue.class != null ? this.config.pteroUtilizationTargetServer() : "";
        Duration eta = this.queueManager.estimateWait(player.getUniqueId(), slotsPerMinute, targetName);
        long m = eta.toMinutes();
        long s = eta.minusMinutes(m).getSeconds();
        player.sendMessage((Component)Component.text((String)("Queue position: " + pos + " | ETA: " + m + "m " + s + "s")));
    }
}

