/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.commands;

import com.velocitypowered.api.command.SimpleCommand;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.texboobcat.catQueue.services.MusicService;

public class QueueMusicCommand
implements SimpleCommand {
    private final MusicService musicService;

    public QueueMusicCommand(MusicService musicService) {
        this.musicService = musicService;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            invocation.source().sendMessage((Component)Component.text((String)"Usage: /queuemusic <list|play <song.nbs>|stop>"));
            return;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                List<String> files = this.musicService.listSongs();
                if (files.isEmpty()) {
                    invocation.source().sendMessage((Component)Component.text((String)"No .nbs songs found in songs folder."));
                    break;
                }
                invocation.source().sendMessage((Component)Component.text((String)("Songs: " + String.join((CharSequence)", ", files))));
                break;
            }
            case "play": {
                if (args.length < 2) {
                    invocation.source().sendMessage((Component)Component.text((String)"Usage: /queuemusic play <song.nbs>"));
                    return;
                }
                String name = args[1];
                boolean ok = this.musicService.loadSongByName(name);
                if (ok) {
                    invocation.source().sendMessage((Component)Component.text((String)("Now playing: " + name)));
                    break;
                }
                invocation.source().sendMessage((Component)Component.text((String)("Failed to load: " + name)));
                break;
            }
            case "stop": {
                this.musicService.stopSong();
                invocation.source().sendMessage((Component)Component.text((String)"Stopped current song."));
                break;
            }
            default: {
                invocation.source().sendMessage((Component)Component.text((String)"Unknown subcommand."));
            }
        }
    }
}

