/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.integrations.DiscordNotifier;

public class QueueSkipCommand
implements SimpleCommand {
    private final QueueManager queueManager;
    private final ConfigManager config;
    private final DiscordNotifier discordNotifier;

    public QueueSkipCommand(QueueManager queueManager, ConfigManager config, DiscordNotifier discordNotifier) {
        this.queueManager = queueManager;
        this.config = config;
        this.discordNotifier = discordNotifier;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage((Component)Component.text((String)"This command is for players."));
            return;
        }
        Player player = (Player)commandSource;
        if (!this.config.skipEnabled()) {
            player.sendMessage((Component)Component.text((String)"Skipping is disabled."));
            return;
        }
        if (!player.hasPermission(this.config.skipPermission())) {
            player.sendMessage((Component)Component.text((String)"You don't have permission to skip."));
            return;
        }
        int delta = 1;
        String[] args = (String[])invocation.arguments();
        if (args.length >= 1) {
            try {
                delta = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        delta = Math.max(1, Math.min(delta, this.config.skipMaxDelta()));
        UUID uuid = player.getUniqueId();
        if (!this.queueManager.isQueued(uuid)) {
            player.sendMessage((Component)Component.text((String)"You're not in the queue."));
            return;
        }
        int pos = this.queueManager.getPosition(uuid);
        if (pos <= 1) {
            player.sendMessage((Component)Component.text((String)"You're already at the front of the queue."));
            return;
        }
        boolean ok = this.queueManager.promote(uuid, delta);
        if (ok) {
            int newPos = this.queueManager.getPosition(uuid);
            player.sendMessage((Component)Component.text((String)("You skipped ahead by " + delta + ". New position: " + newPos + ".")));
            if (this.config.featureDiscord() && this.discordNotifier != null) {
                this.discordNotifier.sendEmbed("Queue Skip", player.getUsername() + " skipped by " + delta + " to pos " + newPos, 16626503);
            }
        } else {
            player.sendMessage((Component)Component.text((String)"Skip failed."));
        }
    }
}

