/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.commands;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.texboobcat.catQueue.services.LeaderboardService;

public class QueueTopCommand
implements SimpleCommand {
    private final ProxyServer server;
    private final LeaderboardService leaderboardService;

    public QueueTopCommand(ProxyServer server, LeaderboardService leaderboardService) {
        this.server = server;
        this.leaderboardService = leaderboardService;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        int end;
        int upto;
        List<Map.Entry<UUID, Long>> top;
        String[] args = (String[])invocation.arguments();
        int page = 1;
        int size = 10;
        if (args.length >= 1) {
            try {
                page = Math.max(1, Integer.parseInt(args[0]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (args.length >= 2) {
            try {
                size = Math.max(1, Integer.parseInt(args[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((top = this.leaderboardService.getTop(upto = Math.min(1000, page * size))).isEmpty()) {
            invocation.source().sendMessage((Component)Component.text((String)"No leaderboard data yet."));
            return;
        }
        int start = Math.min(top.size(), (page - 1) * size);
        if (start >= (end = Math.min(top.size(), start + size))) {
            invocation.source().sendMessage((Component)Component.text((String)"No entries for this page."));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Queue Leaderboard \u2022 Page ").append(page).append(" (size ").append(size).append(")\n");
        for (int i = start; i < end; ++i) {
            Map.Entry<UUID, Long> e = top.get(i);
            String name = this.server.getPlayer(e.getKey()).map(p -> p.getUsername()).orElse(e.getKey().toString());
            long secs = e.getValue();
            sb.append("#").append(i + 1).append("  ").append(name).append("  \u2022  ").append(secs).append("s\n");
        }
        invocation.source().sendMessage((Component)Component.text((String)sb.toString().trim()));
    }
}

