/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.config;

import com.velocitypowered.api.plugin.annotation.DataDirectory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigManager {
    private final Logger logger;
    private final Path configPath;
    private CommentedConfigurationNode root;
    private static final int CURRENT_CONFIG_VERSION = 2;
    private volatile Integer graceMinutesOverride = null;
    private volatile Boolean decayEnabledOverride = null;
    private volatile Integer decayMinutesPerStepOverride = null;
    private volatile Integer decayAmountPerStepOverride = null;
    private volatile Integer decayMinPriorityOverride = null;
    private volatile Boolean pteroEnabledOverride = null;
    private volatile Boolean pteroDryRunOverride = null;
    private volatile Integer pteroQueueDepthThresholdOverride = null;
    private volatile Integer pteroUtilizationPercentThresholdOverride = null;
    private volatile Integer pteroDownUtilizationPercentThresholdOverride = null;
    private volatile Integer pteroDownQueueDepthMaxOverride = null;
    private volatile Integer pteroCooldownUpSecondsOverride = null;
    private volatile Integer pteroCooldownDownSecondsOverride = null;
    private volatile Integer pteroBootBufferSlotsOverride = null;
    private volatile Integer pteroBootBufferSecondsOverride = null;
    private volatile String pteroUtilizationTargetServerOverride = null;
    private static final String DEFAULT_CONFIG = String.join((CharSequence)"\n", "# CatQueue configuration", "configVersion: 2  # used for automatic migrations; do not lower", "# Player queue behavior", "queue:", "  # Hard cap on how many players can be in the queue at once", "  maxSize: 500", "", "  # How fast players are drained from the queue to the target server", "  # This is used for ETA calculations only (does not force teleports)", "  slotsPerMinute: 20", "", "  # Minutes allowed to reconnect and keep your place in line", "  graceMinutes: 3", "", "  # Optional timeouts to warn/kick players who wait too long", "  timeouts:", "    # Warn the player after this many seconds in queue", "    warnSeconds: 600", "    # Remove the player from queue after this many seconds", "    kickSeconds: 900", "", "# Feature toggles for optional modules", "features:", "  timeouts: true     # enable queue timeout warnings/kicks", "  discord: false     # enable Discord webhooks for events", "  leaderboard: false # enable basic queue leaderboard tracking", "", "# Pterodactyl integration", "# - client: day-to-day control with user/client API key (start/stop, state, utilization)", "# - application: provisioning with admin application API key (create new servers)", "pterodactyl:", "  # Master enable for autoscaling that uses Pterodactyl", "  enabled: false", "", "  # If true, only log what would happen; do not call Pterodactyl APIs", "  dryRun: true", "", "  # Panel URL and client (user) API key used for start/stop/status of existing servers", "  baseUrl: ''   # e.g. https://panel.example.com", "  apiKey: ''    # client (user) API key", "", "  # Pool of existing server IDs available for scale-up (client API mode)", "  serverIds: []", "  scale:", "    # Scale-UP when queue depth equals/exceeds this threshold", "    queueDepthThreshold: 25", "    # Scale-UP when target utilization equals/exceeds this percent", "    utilizationPercentThreshold: 85", "    # Scale-DOWN when target utilization stays at/below this percent", "    downUtilizationPercentThreshold: 40", "    # Do NOT scale down if queue depth is still above this max", "    downQueueDepthMax: 5", "    # Name of the server used to measure utilization (e.g. lobby)", "    targetServerName: 'lobby'", "  cooldowns:", "    # Minimum seconds between scale-UP actions", "    scaleUpSeconds: 180", "    # Minimum seconds between scale-DOWN actions", "    scaleDownSeconds: 600", "  buffer:", "    # Keep this many slots worth of capacity booting before counting as ready", "    slots: 10", "    # Consider a booted server \"ready\" after this many seconds as a guard", "    seconds: 120", "", "  # Per-lobby resource guidance used when creating servers (Application API)", "  lobbyResources:", "    memoryMb: 2048   # RAM limit per new lobby", "    diskMb: 10240    # Disk MB per new lobby", "    cpuPercent: 200  # CPU limit (pterodactyl percent units)", "  nodes:", "    # Per-node constraints and server pools", "    node-1:", "      maxLobbies: 2  # cap of concurrently running lobbies on this node", "      nodeId: 0      # Pterodactyl Application Node ID (for creation)", "      serverIds: []  # existing server IDs pinned to this node (optional)", "  application:         # Application API (provisioning). Leave disabled unless you want dynamic creation", "    enabled: false    # when true, autoscaler may create new servers", "    baseUrl: ''       # defaults to pterodactyl.baseUrl if empty", "    apiKey: ''        # application (admin) API key", "    ownerUserId: 0    # server owner user ID in the panel", "    nestId: 0         # optional: restrict to a nest (informational)", "    eggId: 0          # required egg ID for the server to create", "    dockerImage: ''   # docker image to use", "    startup: ''       # startup command line", "    defaultAllocationId: 0  # allocation to attach (or use deploy settings)", "    env: []           # list of KEY=VALUE to set as environment", "    buffer:", "      slots: 10", "      seconds: 120", "", "# Logical player capacity planning (outside of Pterodactyl)", "capacity:", "  default: 100       # default capacity per server when unknown", "  servers:", "    lobby: 200       # override for specific servers", "  autoscale:", "    enabled: false   # enable soft capacity autoscaling mode", "    mode: global     # 'global' or 'target' based calculation", "    playersPerExtraSlot: 25  # how many queued players add one capacity slot", "    maxExtra: 200     # cap on extra capacity", "", "# Discord webhook integration", "discord:", "  webhookUrl: ''     # URL for sending queue/scale events", "", "# Reward players for waiting", "rewards:", "  enabled: false", "  commands:", "    - 'tell %player% Thanks for waiting %wait_seconds%s!'", "", "# Analytics database for metrics/leaderboards", "database:", "  enabled: false", "  jdbcUrl: ''      # e.g. jdbc:sqlite:plugins/CatQueue/catqueue.db or jdbc:mysql://host/db", "  username: ''", "  password: ''", "  tablePrefix: 'catqueue_'", "", "# Player skip feature (VIP/staff) to move up in queue", "skip:", "  enabled: true", "  permission: catqueue.skip  # permission required to use skip", "  maxDelta: 1                 # how many positions to move up", "", "# Fun: note-block style queue music", "music:", "  enabled: false", "  volume: 0.8", "  tempoTicks: 6", "  tempoMode: 'config'  # 'config' or 'file'", "  defaultSong: ''", "  folder: 'songs'", "  notes: [0,2,4,5,7,9,11,12,11,9,7,5,4,2,0]", "", "# Priority system (VIP/staff) and decay over time", "priority:", "  enabled: true", "  staffPermission: catqueue.staff", "  vipPermission: catqueue.vip", "  decay:", "    enabled: true", "    minutesPerStep: 10  # every N minutes in queue", "    amountPerStep: 1    # decrease priority by this amount", "    minPriority: 0      # do not decay below this", "", "# Allow only players with a permission to join the queue", "whitelist:", "  enabled: false", "  permission: catqueue.whitelist", "", "# Messages sent to players", "messages:", "  notifyIntervalTicks: 100  # ticks between queue position updates (5 ticks = 250ms)", "  join: '&aYou entered the queue. Position: %position% (ETA %eta%)'", "  update: '&eQueue update: Position %position% (ETA %eta%)'", "  leave: '&cYou left the queue.'", "  removed: '&cYou were removed from the queue.'", "  priorityJoin: '&6Priority applied. Position: %position%'", "  warnTimeout: '&cYou have been in queue too long. You will be removed soon.'", "  info:", "    enabled: false", "    intervalTicks: 200", "    list:", "      - 'Tip: Join our Discord for updates!'", "      - 'Did you know? Cats sleep 12-16 hours a day.'", "      - 'Server news: Events every weekend!'", "  actionBar:", "    enabled: true              # constantly show queue position/ETA in action bar", "    intervalTicks: 20          # how often to refresh action bar (20 ticks = 1s)", "    text: '&eQueue %position% \u2022 ETA %eta%'");

    public ConfigManager(Logger logger, @DataDirectory Path dataDir) {
        this.logger = logger;
        this.configPath = dataDir.resolve("config.yml");
    }

    public boolean skipEnabled() {
        return this.node("skip", "enabled").getBoolean(true);
    }

    public String skipPermission() {
        return this.node("skip", "permission").getString("catqueue.skip");
    }

    public int skipMaxDelta() {
        return this.node("skip", "maxDelta").getInt(1);
    }

    public boolean infoEnabled() {
        return this.node("messages", "info", "enabled").getBoolean(false);
    }

    public int infoIntervalTicks() {
        return this.node("messages", "info", "intervalTicks").getInt(200);
    }

    public boolean musicEnabled() {
        return this.node("music", "enabled").getBoolean(false);
    }

    public float musicVolume() {
        return (float)this.node("music", "volume").getDouble(0.8);
    }

    public int musicTempoTicks() {
        return this.node("music", "tempoTicks").getInt(6);
    }

    public String musicTempoMode() {
        return this.node("music", "tempoMode").getString("config");
    }

    public String musicDefaultSong() {
        return this.node("music", "defaultSong").getString("");
    }

    public String musicFolder() {
        return this.node("music", "folder").getString("songs");
    }

    public List<Integer> musicNotes() {
        List<Integer> def = List.of(0, 2, 4, 5, 7, 9, 11, 12, 11, 9, 7, 5, 4, 2, 0);
        try {
            return this.node("music", "notes").getList(Integer.class, def);
        }
        catch (SerializationException e) {
            return def;
        }
    }

    public boolean dbEnabled() {
        return this.node("database", "enabled").getBoolean(false);
    }

    public String dbJdbcUrl() {
        return this.node("database", "jdbcUrl").getString("");
    }

    public String dbUser() {
        return this.node("database", "username").getString("");
    }

    public String dbPass() {
        return this.node("database", "password").getString("");
    }

    public String dbTablePrefix() {
        return this.node("database", "tablePrefix").getString("catqueue_");
    }

    public void load() {
        try {
            if (Files.notExists(this.configPath, new LinkOption[0])) {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                Files.writeString(this.configPath, (CharSequence)DEFAULT_CONFIG, new OpenOption[0]);
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.configPath)).build();
            this.root = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults());
            boolean migrated = this.migrateIfNeeded(this.root);
            if (migrated) {
                try {
                    Path migratedPath = this.configPath.resolveSibling("config.migrated.yml");
                    YamlConfigurationLoader migratedLoader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(migratedPath)).build();
                    migratedLoader.save(this.root);
                    this.logger.info("Config migration performed in-memory (v{}). Wrote '{}' for your review; original 'config.yml' left untouched.", (Object)2, (Object)migratedPath.getFileName());
                    this.logger.info("You can replace config.yml with config.migrated.yml or manually merge the new keys and 'configVersion'.");
                }
                catch (IOException e) {
                    this.logger.warn("Failed to write migrated config copy: {}", (Object)e.toString());
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load config: {}", (Object)e.toString());
        }
    }

    private boolean migrateIfNeeded(CommentedConfigurationNode root) {
        CommentedConfigurationNode app;
        boolean changed = false;
        int version = ((CommentedConfigurationNode)root.node(new Object[]{"configVersion"})).getInt(0);
        if (version < 1 && !(app = (CommentedConfigurationNode)root.node(new Object[]{"application"})).virtual() && app.childrenMap() != null && !app.childrenMap().isEmpty()) {
            try {
                ((CommentedConfigurationNode)root.node(new Object[]{"pterodactyl", "application"})).set(app);
                app.raw(null);
                changed = true;
            }
            catch (SerializationException e) {
                this.logger.warn("Config migration v1 failed to move application block: {}", (Object)e.toString());
            }
        }
        if (version < 2) {
            CommentedConfigurationNode ab = (CommentedConfigurationNode)root.node(new Object[]{"messages", "actionBar"});
            try {
                if (((CommentedConfigurationNode)ab.node(new Object[]{"enabled"})).virtual()) {
                    ((CommentedConfigurationNode)ab.node(new Object[]{"enabled"})).set(true);
                    changed = true;
                }
                if (((CommentedConfigurationNode)ab.node(new Object[]{"intervalTicks"})).virtual()) {
                    ((CommentedConfigurationNode)ab.node(new Object[]{"intervalTicks"})).set(20);
                    changed = true;
                }
                if (((CommentedConfigurationNode)ab.node(new Object[]{"text"})).virtual()) {
                    ((CommentedConfigurationNode)ab.node(new Object[]{"text"})).set("&eQueue %position% \u2022 ETA %eta%");
                    changed = true;
                }
            }
            catch (SerializationException e) {
                this.logger.warn("Config migration v2 failed to set actionBar defaults: {}", (Object)e.toString());
            }
        }
        if (version < 2) {
            try {
                ((CommentedConfigurationNode)root.node(new Object[]{"configVersion"})).set(2);
                changed = true;
            }
            catch (SerializationException e) {
                this.logger.warn("Failed to bump configVersion to {}: {}", (Object)2, (Object)e.toString());
            }
        }
        return changed;
    }

    public CommentedConfigurationNode node(String ... path) {
        if (this.root == null) {
            this.load();
        }
        return (CommentedConfigurationNode)this.root.node(path);
    }

    public int maxQueueSize() {
        return this.node("queue", "maxSize").getInt(500);
    }

    public int slotsPerMinute() {
        return this.node("queue", "slotsPerMinute").getInt(20);
    }

    public int graceMinutes() {
        return this.node("queue", "graceMinutes").getInt(3);
    }

    public int getGraceMinutesEffective() {
        return this.graceMinutesOverride != null ? this.graceMinutesOverride.intValue() : this.graceMinutes();
    }

    public void setGraceMinutesOverride(Integer minutes) {
        this.graceMinutesOverride = minutes;
    }

    public int notifyIntervalTicks() {
        return this.node("messages", "notifyIntervalTicks").getInt(100);
    }

    public boolean priorityEnabled() {
        return this.node("priority", "enabled").getBoolean(true);
    }

    public boolean decayEnabled() {
        return this.decayEnabledOverride != null ? this.decayEnabledOverride.booleanValue() : this.node("priority", "decay", "enabled").getBoolean(true);
    }

    public int decayMinutesPerStep() {
        return this.decayMinutesPerStepOverride != null ? this.decayMinutesPerStepOverride.intValue() : this.node("priority", "decay", "minutesPerStep").getInt(10);
    }

    public int decayAmountPerStep() {
        return this.decayAmountPerStepOverride != null ? this.decayAmountPerStepOverride.intValue() : this.node("priority", "decay", "amountPerStep").getInt(1);
    }

    public int decayMinPriority() {
        return this.decayMinPriorityOverride != null ? this.decayMinPriorityOverride.intValue() : this.node("priority", "decay", "minPriority").getInt(0);
    }

    public void setDecayEnabledOverride(Boolean v) {
        this.decayEnabledOverride = v;
    }

    public void setDecayMinutesPerStepOverride(Integer v) {
        this.decayMinutesPerStepOverride = v;
    }

    public void setDecayAmountPerStepOverride(Integer v) {
        this.decayAmountPerStepOverride = v;
    }

    public void setDecayMinPriorityOverride(Integer v) {
        this.decayMinPriorityOverride = v;
    }

    public String vipPermission() {
        return this.node("priority", "vipPermission").getString("catqueue.vip");
    }

    public String staffPermission() {
        return this.node("priority", "staffPermission").getString("catqueue.staff");
    }

    public boolean whitelistEnabled() {
        return this.node("whitelist", "enabled").getBoolean(false);
    }

    public String whitelistPermission() {
        return this.node("whitelist", "permission").getString("catqueue.whitelist");
    }

    public String msgJoin() {
        return this.node("messages", "join").getString("You entered the queue. Position %position% (ETA %eta%)");
    }

    public String msgUpdate() {
        return this.node("messages", "update").getString("Queue update: Position %position% (ETA %eta%)");
    }

    public String msgLeave() {
        return this.node("messages", "leave").getString("You left the queue.");
    }

    public String msgRemoved() {
        return this.node("messages", "removed").getString("You were removed from the queue.");
    }

    public String msgPriorityJoin() {
        return this.node("messages", "priorityJoin").getString("Priority applied. Position: %position%");
    }

    public String msgWarnTimeout() {
        return this.node("messages", "warnTimeout").getString("You have been in queue too long. You will be removed soon.");
    }

    public boolean actionBarEnabled() {
        return this.node("messages", "actionBar", "enabled").getBoolean(true);
    }

    public int actionBarIntervalTicks() {
        return this.node("messages", "actionBar", "intervalTicks").getInt(20);
    }

    public String msgActionBar() {
        return this.node("messages", "actionBar", "text").getString("Queue %position% \u2022 ETA %eta%");
    }

    public List<String> infoMessages() {
        List<String> def = List.of("Tip: Join our Discord for updates!", "Did you know? Cats sleep 12-16 hours a day.", "Server news: Events every weekend!");
        try {
            return this.node("messages", "info").getList(String.class, def);
        }
        catch (SerializationException e) {
            return def;
        }
    }

    public boolean featureTimeouts() {
        return this.node("features", "timeouts").getBoolean(true);
    }

    public boolean featureDiscord() {
        return this.node("features", "discord").getBoolean(false);
    }

    public boolean featureLeaderboard() {
        return this.node("features", "leaderboard").getBoolean(false);
    }

    public int timeoutWarnSeconds() {
        return this.node("queue", "timeouts", "warnSeconds").getInt(600);
    }

    public int timeoutKickSeconds() {
        return this.node("queue", "timeouts", "kickSeconds").getInt(900);
    }

    public int defaultServerCapacity() {
        return this.node("capacity", "default").getInt(100);
    }

    public int serverCapacity(String server) {
        return this.node("capacity", "servers", server).getInt(this.defaultServerCapacity());
    }

    public boolean autoscaleEnabled() {
        return this.node("capacity", "autoscale", "enabled").getBoolean(false);
    }

    public int autoscalePlayersPerExtraSlot() {
        return this.node("capacity", "autoscale", "playersPerExtraSlot").getInt(25);
    }

    public int autoscaleMaxExtra() {
        return this.node("capacity", "autoscale", "maxExtra").getInt(200);
    }

    public String autoscaleMode() {
        return this.node("capacity", "autoscale", "mode").getString("global");
    }

    public boolean pteroEnabled() {
        return this.pteroEnabledOverride != null ? this.pteroEnabledOverride.booleanValue() : this.node("pterodactyl", "enabled").getBoolean(false);
    }

    public boolean pteroDryRun() {
        return this.pteroDryRunOverride != null ? this.pteroDryRunOverride.booleanValue() : this.node("pterodactyl", "dryRun").getBoolean(true);
    }

    public String pteroBaseUrl() {
        return this.node("pterodactyl", "baseUrl").getString("");
    }

    public String pteroApiKey() {
        return this.node("pterodactyl", "apiKey").getString("");
    }

    public List<String> pteroServerIds() {
        List<String> def = List.of();
        try {
            return this.node("pterodactyl", "serverIds").getList(String.class, def);
        }
        catch (SerializationException e) {
            return def;
        }
    }

    public int pteroQueueDepthThreshold() {
        return this.pteroQueueDepthThresholdOverride != null ? this.pteroQueueDepthThresholdOverride.intValue() : this.node("pterodactyl", "scale", "queueDepthThreshold").getInt(25);
    }

    public int pteroUtilizationPercentThreshold() {
        return this.pteroUtilizationPercentThresholdOverride != null ? this.pteroUtilizationPercentThresholdOverride.intValue() : this.node("pterodactyl", "scale", "utilizationPercentThreshold").getInt(85);
    }

    public String pteroUtilizationTargetServer() {
        return this.pteroUtilizationTargetServerOverride != null ? this.pteroUtilizationTargetServerOverride : this.node("pterodactyl", "scale", "targetServerName").getString("lobby");
    }

    public int pteroDownUtilizationPercentThreshold() {
        return this.pteroDownUtilizationPercentThresholdOverride != null ? this.pteroDownUtilizationPercentThresholdOverride.intValue() : this.node("pterodactyl", "scale", "downUtilizationPercentThreshold").getInt(40);
    }

    public int pteroDownQueueDepthMax() {
        return this.pteroDownQueueDepthMaxOverride != null ? this.pteroDownQueueDepthMaxOverride.intValue() : this.node("pterodactyl", "scale", "downQueueDepthMax").getInt(5);
    }

    public int pteroCooldownUpSeconds() {
        return this.pteroCooldownUpSecondsOverride != null ? this.pteroCooldownUpSecondsOverride.intValue() : this.node("pterodactyl", "cooldowns", "scaleUpSeconds").getInt(180);
    }

    public int pteroCooldownDownSeconds() {
        return this.pteroCooldownDownSecondsOverride != null ? this.pteroCooldownDownSecondsOverride.intValue() : this.node("pterodactyl", "cooldowns", "scaleDownSeconds").getInt(600);
    }

    public int pteroBootBufferSlots() {
        return this.pteroBootBufferSlotsOverride != null ? this.pteroBootBufferSlotsOverride.intValue() : this.node("pterodactyl", "buffer", "slots").getInt(10);
    }

    public int pteroBootBufferSeconds() {
        return this.pteroBootBufferSecondsOverride != null ? this.pteroBootBufferSecondsOverride.intValue() : this.node("pterodactyl", "buffer", "seconds").getInt(120);
    }

    public void setPteroEnabledOverride(Boolean v) {
        this.pteroEnabledOverride = v;
    }

    public void setPteroDryRunOverride(Boolean v) {
        this.pteroDryRunOverride = v;
    }

    public void setPteroQueueDepthThresholdOverride(Integer v) {
        this.pteroQueueDepthThresholdOverride = v;
    }

    public void setPteroUtilizationPercentThresholdOverride(Integer v) {
        this.pteroUtilizationPercentThresholdOverride = v;
    }

    public void setPteroDownUtilizationPercentThresholdOverride(Integer v) {
        this.pteroDownUtilizationPercentThresholdOverride = v;
    }

    public void setPteroDownQueueDepthMaxOverride(Integer v) {
        this.pteroDownQueueDepthMaxOverride = v;
    }

    public void setPteroCooldownUpSecondsOverride(Integer v) {
        this.pteroCooldownUpSecondsOverride = v;
    }

    public void setPteroCooldownDownSecondsOverride(Integer v) {
        this.pteroCooldownDownSecondsOverride = v;
    }

    public void setPteroBootBufferSlotsOverride(Integer v) {
        this.pteroBootBufferSlotsOverride = v;
    }

    public void setPteroBootBufferSecondsOverride(Integer v) {
        this.pteroBootBufferSecondsOverride = v;
    }

    public void setPteroUtilizationTargetServerOverride(String v) {
        this.pteroUtilizationTargetServerOverride = v;
    }

    public int pteroLobbyMemoryMb() {
        return this.node("pterodactyl", "lobbyResources", "memoryMb").getInt(2048);
    }

    public int pteroLobbyDiskMb() {
        return this.node("pterodactyl", "lobbyResources", "diskMb").getInt(10240);
    }

    public int pteroLobbyCpuPercent() {
        return this.node("pterodactyl", "lobbyResources", "cpuPercent").getInt(200);
    }

    public List<NodeDef> pteroNodes() {
        ArrayList<NodeDef> out;
        block5: {
            out = new ArrayList<NodeDef>();
            try {
                Map map = this.node("pterodactyl", "nodes").childrenMap();
                if (map == null) break block5;
                for (Map.Entry e : map.entrySet()) {
                    List<String> ids;
                    String name = String.valueOf(e.getKey());
                    CommentedConfigurationNode sub = (CommentedConfigurationNode)e.getValue();
                    int max = ((CommentedConfigurationNode)sub.node(new Object[]{"maxLobbies"})).getInt(0);
                    try {
                        ids = ((CommentedConfigurationNode)sub.node(new Object[]{"serverIds"})).getList(String.class, List.of());
                    }
                    catch (SerializationException ex) {
                        ids = List.of();
                    }
                    int nodeId = ((CommentedConfigurationNode)sub.node(new Object[]{"nodeId"})).getInt(0);
                    out.add(new NodeDef(name, max, ids, nodeId));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    public boolean pteroAppEnabled() {
        return this.node("pterodactyl", "application", "enabled").getBoolean(false);
    }

    public String pteroAppBaseUrl() {
        return this.node("pterodactyl", "application", "baseUrl").getString(this.pteroBaseUrl());
    }

    public String pteroAppApiKey() {
        return this.node("pterodactyl", "application", "apiKey").getString("");
    }

    public int pteroAppNestId() {
        return this.node("pterodactyl", "application", "nestId").getInt(0);
    }

    public int pteroAppEggId() {
        return this.node("pterodactyl", "application", "eggId").getInt(0);
    }

    public String pteroAppDockerImage() {
        return this.node("pterodactyl", "application", "dockerImage").getString("");
    }

    public String pteroAppStartup() {
        return this.node("pterodactyl", "application", "startup").getString("");
    }

    public int pteroAppOwnerUserId() {
        return this.node("pterodactyl", "application", "ownerUserId").getInt(0);
    }

    public int pteroAppDefaultAllocationId() {
        return this.node("pterodactyl", "application", "defaultAllocationId").getInt(0);
    }

    public List<String> pteroAppEnvList() {
        List<String> def = List.of();
        try {
            return this.node("pterodactyl", "application", "env").getList(String.class, def);
        }
        catch (SerializationException e) {
            return def;
        }
    }

    public String discordWebhookUrl() {
        return this.node("discord", "webhookUrl").getString("");
    }

    public boolean rewardsEnabled() {
        return this.node("rewards", "enabled").getBoolean(false);
    }

    public List<String> rewardCommands() {
        List<String> def = List.of("tell %player% Thanks for waiting %wait_seconds%s!");
        try {
            return this.node("rewards", "commands").getList(String.class, def);
        }
        catch (SerializationException e) {
            return def;
        }
    }

    public static class NodeDef {
        public final String name;
        public final int maxLobbies;
        public final List<String> serverIds;
        public final int nodeId;

        public NodeDef(String name, int maxLobbies, List<String> serverIds, int nodeId) {
            this.name = name;
            this.maxLobbies = maxLobbies;
            this.serverIds = serverIds;
            this.nodeId = nodeId;
        }
    }
}

