/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.integrations;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public class DiscordNotifier {
    private final Logger logger;
    private final String webhookUrl;

    public DiscordNotifier(Logger logger, String webhookUrl) {
        this.logger = logger;
        this.webhookUrl = webhookUrl;
    }

    public void send(String content) {
        if (this.webhookUrl == null || this.webhookUrl.isBlank()) {
            return;
        }
        try {
            URL url = new URL(this.webhookUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            String payload = "{\"content\":" + this.quote(content) + "}";
            try (OutputStream os = con.getOutputStream();){
                os.write(payload.getBytes(StandardCharsets.UTF_8));
            }
            int code = con.getResponseCode();
            if (code < 200 || code >= 300) {
                this.logger.debug("Discord webhook responded {}", (Object)code);
            }
        }
        catch (Exception e) {
            this.logger.debug("Discord webhook failed: {}", (Object)e.toString());
        }
    }

    public void sendEmbed(String title, String description, int color) {
        if (this.webhookUrl == null || this.webhookUrl.isBlank()) {
            return;
        }
        try {
            URL url = new URL(this.webhookUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            String embed = "{\"title\":" + this.quote(this.nullToEmpty(title)) + ",\"description\":" + this.quote(this.nullToEmpty(description)) + ",\"color\":" + Math.max(0, color) + "}";
            String payload = "{\"embeds\":[" + embed + "]}";
            try (OutputStream os = con.getOutputStream();){
                os.write(payload.getBytes(StandardCharsets.UTF_8));
            }
            int code = con.getResponseCode();
            if (code < 200 || code >= 300) {
                this.logger.debug("Discord webhook responded {}", (Object)code);
            }
        }
        catch (Exception e) {
            this.logger.debug("Discord webhook failed: {}", (Object)e.toString());
        }
    }

    private String quote(String s) {
        String esc = s.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + esc + "\"";
    }

    private String nullToEmpty(String s) {
        return s == null ? "" : s;
    }
}

