/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.integrations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;

public class PterodactylAppClient {
    private final Logger logger;
    private final ConfigManager config;
    private final HttpClient http = HttpClient.newHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public PterodactylAppClient(Logger logger, ConfigManager config) {
        this.logger = logger;
        this.config = config;
    }

    public String createLobbyServer(int nodeId, String name) throws Exception {
        if (!this.config.pteroAppEnabled()) {
            throw new IllegalStateException("Application API not enabled");
        }
        String base = this.config.pteroAppBaseUrl();
        String url = this.trimSlash(base) + "/api/application/servers";
        HashMap<String, String> env = new HashMap<String, String>();
        for (String kv : this.config.pteroAppEnvList()) {
            int eq = kv.indexOf(61);
            if (eq <= 0) continue;
            env.put(kv.substring(0, eq), kv.substring(eq + 1));
        }
        ObjectNode root = this.objectMapper.createObjectNode();
        root.put("name", name);
        root.put("user", this.config.pteroAppOwnerUserId());
        root.put("egg", this.config.pteroAppEggId());
        root.put("docker_image", this.config.pteroAppDockerImage());
        root.put("startup", this.config.pteroAppStartup());
        ObjectNode envNode = this.objectMapper.createObjectNode();
        for (Map.Entry e : env.entrySet()) {
            envNode.put((String)e.getKey(), (String)e.getValue());
        }
        root.set("environment", envNode);
        ObjectNode limits = this.objectMapper.createObjectNode();
        limits.put("memory", this.config.pteroLobbyMemoryMb());
        limits.put("swap", 0);
        limits.put("disk", this.config.pteroLobbyDiskMb());
        limits.put("io", 500);
        limits.put("cpu", this.config.pteroLobbyCpuPercent());
        root.set("limits", limits);
        ObjectNode feats = this.objectMapper.createObjectNode();
        feats.put("databases", 2);
        feats.put("backups", 2);
        root.set("feature_limits", feats);
        ObjectNode alloc = this.objectMapper.createObjectNode();
        alloc.put("default", this.config.pteroAppDefaultAllocationId());
        root.set("allocation", alloc);
        ObjectNode deploy = this.objectMapper.createObjectNode();
        ArrayNode locs = this.objectMapper.createArrayNode();
        locs.add(nodeId);
        deploy.set("locations", locs);
        deploy.put("dedicated_ip", false);
        deploy.set("port_range", this.objectMapper.createArrayNode());
        root.set("deploy", deploy);
        root.put("start_on_completion", true);
        String json = this.objectMapper.writeValueAsString(root);
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).header("Authorization", "Bearer " + this.config.pteroAppApiKey()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        HttpResponse<String> resp = this.http.send(req, HttpResponse.BodyHandlers.ofString());
        if (resp.statusCode() / 100 != 2) {
            this.logger.warn("Pterodactyl Application create non-2xx: {} body={}", (Object)resp.statusCode(), (Object)resp.body());
            return null;
        }
        try {
            JsonNode body = this.objectMapper.readTree(resp.body());
            String id = this.findStringField(body, "identifier");
            if (id != null && !id.isEmpty()) {
                return id;
            }
            id = this.findStringField(body, "uuid");
            return id;
        }
        catch (Exception ex) {
            this.logger.warn("Pterodactyl Application parse error: {}", (Object)ex.toString());
            return null;
        }
    }

    private String trimSlash(String base) {
        if (base == null) {
            return "";
        }
        if (base.endsWith("/")) {
            return base.substring(0, base.length() - 1);
        }
        return base;
    }

    private String findStringField(JsonNode node, String field) {
        JsonNode d;
        String v;
        JsonNode a;
        if (node == null) {
            return null;
        }
        if (node.has(field) && node.get(field).isTextual()) {
            return node.get(field).asText();
        }
        if (node.has("attributes") && (a = node.get("attributes")) != null && a.has(field) && a.get(field).isTextual()) {
            return a.get(field).asText();
        }
        if (node.has("data") && (v = this.findStringField(d = node.get("data"), field)) != null) {
            return v;
        }
        Iterator<JsonNode> it = node.elements();
        while (it.hasNext()) {
            v = this.findStringField(it.next(), field);
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

