/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.integrations.DiscordNotifier;
import org.texboobcat.catQueue.services.AnalyticsService;
import org.texboobcat.catQueue.services.CapacityService;
import org.texboobcat.catQueue.services.LeaderboardService;
import org.texboobcat.catQueue.services.RewardService;
import org.texboobcat.catQueue.util.MessageUtil;

public class ConnectListener {
    private final QueueManager queueManager;
    private final ConfigManager config;
    private final Logger logger;
    private final RewardService rewardService;
    private final LeaderboardService leaderboardService;
    private final DiscordNotifier discordNotifier;
    private final CapacityService capacityService;
    private final AnalyticsService analyticsService;

    public ConnectListener(QueueManager queueManager, ConfigManager config, Logger logger, ProxyServer server, RewardService rewardService, LeaderboardService leaderboardService, DiscordNotifier discordNotifier, CapacityService capacityService, AnalyticsService analyticsService) {
        this.queueManager = queueManager;
        this.config = config;
        this.logger = logger;
        this.rewardService = rewardService;
        this.leaderboardService = leaderboardService;
        this.discordNotifier = discordNotifier;
        this.capacityService = capacityService;
        this.analyticsService = analyticsService;
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent event) {
        Player player = event.getPlayer();
        if (this.config.whitelistEnabled() && player.hasPermission(this.config.whitelistPermission())) {
            this.logger.debug("{} bypassed queue via whitelist.", (Object)player.getUsername());
            return;
        }
        boolean restored = this.queueManager.tryRestoreFromGrace(player.getUniqueId());
        if (!restored) {
            boolean isStaff = player.hasPermission(this.config.staffPermission());
            boolean isVip = player.hasPermission(this.config.vipPermission());
            int priority = this.queueManager.resolvePriority(isStaff, isVip);
            this.queueManager.enqueue(player.getUniqueId(), priority);
        }
        int pos = this.queueManager.getPosition(player.getUniqueId());
        String targetName = this.config.pteroUtilizationTargetServer();
        Duration eta = this.queueManager.estimateWait(player.getUniqueId(), this.config.slotsPerMinute(), targetName);
        HashMap<String, String> ph = new HashMap<String, String>();
        ph.put("position", String.valueOf(pos));
        ph.put("eta", MessageUtil.humanize(eta));
        String msg = restored ? MessageUtil.apply(this.config.msgJoin(), ph) : MessageUtil.apply(this.config.msgJoin(), ph);
        player.sendMessage((Component)Component.text((String)msg));
        if (this.config.featureDiscord()) {
            String desc = player.getUsername() + (restored ? " rejoined the queue (grace)" : " joined the queue") + " \u2022 Pos " + pos + " \u2022 ETA " + MessageUtil.humanize(eta);
            this.discordNotifier.sendEmbed("Player Queued", desc, 6989903);
        }
    }

    @Subscribe
    public void onServerPreConnect(ServerPreConnectEvent event) {
        boolean capacityAvailable;
        Player player = event.getPlayer();
        if (!this.queueManager.isQueued(player.getUniqueId())) {
            return;
        }
        int pos = this.queueManager.getPosition(player.getUniqueId());
        RegisteredServer target = event.getOriginalServer();
        if (target == null) {
            return;
        }
        int cap = this.capacityService.getCapacity(target.getServerInfo().getName());
        int online = target.getPlayersConnected().size();
        boolean bl = capacityAvailable = online < cap;
        if (!capacityAvailable) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
            return;
        }
        if (pos > 1) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
            return;
        }
        this.queueManager.getEntry(player.getUniqueId()).ifPresent(e -> {
            Duration waited = Duration.between(e.joinedAt, Instant.now());
            String nice = MessageUtil.humanize(waited);
            player.sendMessage((Component)Component.text((String)("Thanks for waiting ~" + nice + ". Enjoy!")));
            try {
                this.leaderboardService.recordWait(player.getUniqueId(), waited);
                this.rewardService.grantWaitReward(player.getUniqueId(), waited);
                if (this.analyticsService != null) {
                    this.analyticsService.recordWait(player.getUniqueId(), e.priority, Math.max(0L, waited.getSeconds()));
                }
                if (this.config.featureDiscord()) {
                    this.discordNotifier.send(player.getUsername() + " joined after waiting " + nice + ".");
                }
            }
            catch (Exception ex) {
                this.logger.debug("Post-join hooks failed: {}", (Object)ex.toString());
            }
        });
        this.queueManager.pollNext(target.getServerInfo().getName());
    }
}

