/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.integrations.DiscordNotifier;

public class QueueListener {
    private final QueueManager queueManager;
    private final Logger logger;
    private final ConfigManager config;
    private final DiscordNotifier discordNotifier;

    public QueueListener(QueueManager queueManager, Logger logger, ConfigManager config, DiscordNotifier discordNotifier) {
        this.queueManager = queueManager;
        this.logger = logger;
        this.config = config;
        this.discordNotifier = discordNotifier;
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        this.queueManager.saveGraceOnDisconnect(event.getPlayer().getUniqueId(), this.config.graceMinutes());
        this.logger.debug("Saved grace for {} on disconnect.", (Object)event.getPlayer().getUsername());
        if (this.config.featureDiscord()) {
            try {
                this.discordNotifier.send("Left queue (grace): " + event.getPlayer().getUsername());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

