/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.music;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.texboobcat.catQueue.music.NbsSong;

public class NbsParser {
    private final Logger logger;

    public NbsParser(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NbsSong parse(File file) throws IOException {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            boolean v5;
            int first = this.readShortLE(in);
            boolean bl = v5 = first == 65535;
            if (v5) {
                in.readUnsignedByte();
                in.readUnsignedByte();
                this.readIntLE(in);
                int layers = this.readShortLE(in);
                this.readString(in);
                this.readString(in);
                this.readString(in);
                this.readString(in);
                int tempoHundredths = this.readShortLE(in);
                try {
                    if (tempoHundredths <= 0) {
                        // empty if block
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                float tps = Math.max(1.0f, (float)tempoHundredths / 100.0f);
                NbsSong song = new NbsSong();
                song.setTempoTps(tps);
                song.initLayers(Math.max(0, layers));
                NbsSong nbsSong = this.parseNotesAndLayers(in, song, true, layers);
                return nbsSong;
            }
            int layers = this.readShortLE(in);
            this.readString(in);
            this.readString(in);
            this.readString(in);
            this.readString(in);
            this.readShortLE(in);
            NbsSong song = new NbsSong();
            song.initLayers(Math.max(0, layers));
            NbsSong nbsSong = this.parseNotesAndLayers(in, song, false, layers);
            return nbsSong;
        }
        catch (EOFException eof) {
            this.logger.debug("NBS parse reached EOF early: {}", (Object)eof.toString());
            throw eof;
        }
        catch (IOException ex) {
            this.logger.warn("Failed to parse NBS file {}: {}", (Object)file.getName(), (Object)ex.toString());
            throw ex;
        }
    }

    private int readShortLE(DataInputStream in) throws IOException {
        int b1 = in.readUnsignedByte();
        int b2 = in.readUnsignedByte();
        return b2 << 8 | b1;
    }

    private String readString(DataInputStream in) throws IOException {
        int len = this.readIntLE(in);
        if (len <= 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        int r = in.read(bytes);
        if (r != len) {
            throw new EOFException("Unexpected EOF reading string");
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private int readIntLE(DataInputStream in) throws IOException {
        int b1 = in.readUnsignedByte();
        int b2 = in.readUnsignedByte();
        int b3 = in.readUnsignedByte();
        int b4 = in.readUnsignedByte();
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private NbsSong parseNotesAndLayers(DataInputStream in, NbsSong song, boolean v5, int layers) throws IOException {
        int jumpTicks;
        int currentTick = -1;
        while ((jumpTicks = this.readShortLE(in)) != 0) {
            int jumpLayers;
            currentTick += jumpTicks;
            int currentLayer = -1;
            while ((jumpLayers = this.readShortLE(in)) != 0) {
                currentLayer += jumpLayers;
                int instrument = in.readUnsignedByte();
                int key = in.readUnsignedByte();
                if (v5) {
                    try {
                        int velocity = in.readUnsignedByte();
                        in.readByte();
                        int fine = this.readShortLE(in);
                        int fineCents = Math.max(-120, Math.min(120, fine));
                        song.addNote(currentTick, instrument, key, velocity, currentLayer, fineCents);
                        continue;
                    }
                    catch (EOFException eof) {
                        song.addNote(currentTick, instrument, key);
                        return song;
                    }
                }
                song.addNote(currentTick, instrument, key);
            }
        }
        if (v5 && layers > 0) {
            for (int i = 0; i < layers; ++i) {
                try {
                    this.readString(in);
                    in.readUnsignedByte();
                    int vol = in.readUnsignedByte();
                    byte pan = 0;
                    try {
                        pan = in.readByte();
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    song.setLayerMeta(i, vol, Integer.valueOf(pan));
                    continue;
                }
                catch (EOFException eof) {
                    break;
                }
            }
        }
        return song;
    }
}

