/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.music;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NbsSong {
    private final Map<Integer, List<NoteEvent>> notesByTick = new HashMap<Integer, List<NoteEvent>>();
    private int lengthTicks = 0;
    private float tempoTps = 10.0f;
    private int[] layerVolumes = new int[0];
    private int[] layerPans = new int[0];

    public void addNote(int tick, int instrument, int key) {
        this.notesByTick.computeIfAbsent(tick, k -> new ArrayList()).add(new NoteEvent(instrument, key));
        if (tick + 1 > this.lengthTicks) {
            this.lengthTicks = tick + 1;
        }
    }

    public void addNote(int tick, int instrument, int key, int velocity) {
        this.notesByTick.computeIfAbsent(tick, k -> new ArrayList()).add(new NoteEvent(instrument, key, velocity));
        if (tick + 1 > this.lengthTicks) {
            this.lengthTicks = tick + 1;
        }
    }

    public void addNote(int tick, int instrument, int key, int velocity, int layer, int fineCents) {
        this.notesByTick.computeIfAbsent(tick, k -> new ArrayList()).add(new NoteEvent(instrument, key, velocity, layer, fineCents));
        if (tick + 1 > this.lengthTicks) {
            this.lengthTicks = tick + 1;
        }
    }

    public List<NoteEvent> eventsAt(int tick) {
        return this.notesByTick.getOrDefault(tick, Collections.emptyList());
    }

    public int lengthTicks() {
        return this.lengthTicks;
    }

    public void setTempoTps(float tps) {
        this.tempoTps = tps;
    }

    public float tempoTps() {
        return this.tempoTps;
    }

    public void initLayers(int count) {
        this.layerVolumes = new int[count];
        this.layerPans = new int[count];
        Arrays.fill(this.layerVolumes, 100);
        Arrays.fill(this.layerPans, 0);
    }

    public void setLayerMeta(int idx, Integer volume, Integer pan) {
        if (idx < 0 || idx >= this.layerVolumes.length) {
            return;
        }
        if (volume != null) {
            this.layerVolumes[idx] = Math.max(0, Math.min(100, volume));
        }
        if (pan != null) {
            this.layerPans[idx] = Math.max(-100, Math.min(100, pan));
        }
    }

    public int layerVolume(int idx) {
        return idx >= 0 && idx < this.layerVolumes.length ? this.layerVolumes[idx] : 100;
    }

    public int layerPan(int idx) {
        return idx >= 0 && idx < this.layerPans.length ? this.layerPans[idx] : 0;
    }

    public static class NoteEvent {
        public final int instrument;
        public final int key;
        public final int velocity;
        public final int layer;
        public final int fineCents;

        public NoteEvent(int instrument, int key) {
            this(instrument, key, 100);
        }

        public NoteEvent(int instrument, int key, int velocity) {
            this(instrument, key, velocity, -1, 0);
        }

        public NoteEvent(int instrument, int key, int velocity, int layer, int fineCents) {
            this.instrument = instrument;
            this.key = key;
            this.velocity = Math.max(0, Math.min(100, velocity));
            this.layer = layer;
            this.fineCents = fineCents;
        }
    }
}

