/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.texboobcat.catQueue.core.QueueManager;

public class PersistenceManager {
    private final Logger logger;
    private final Path saveFile;
    private final Path leaderboardFile;

    public PersistenceManager(Logger logger, Path dataDir) {
        this.logger = logger;
        this.saveFile = dataDir.resolve("queue_state.csv");
        this.leaderboardFile = dataDir.resolve("leaderboard.csv");
    }

    public void save(QueueManager manager) {
        try {
            Files.createDirectories(this.saveFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(this.saveFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                w.write("uuid,priority,joinedEpoch\n");
                for (UUID uuid : manager.listQueued()) {
                    QueueManager.QueueEntry e = manager.getEntry(uuid).orElse(null);
                    if (e == null) continue;
                    long epoch = e.joinedAt.getEpochSecond();
                    w.write(uuid + "," + e.priority + "," + epoch + "\n");
                }
            }
        }
        catch (IOException ex) {
            this.logger.warn("Failed to save queue state: {}", (Object)ex.toString());
        }
    }

    public List<Record> load() {
        ArrayList<Record> records = new ArrayList<Record>();
        if (Files.notExists(this.saveFile, new LinkOption[0])) {
            return records;
        }
        try (BufferedReader r = Files.newBufferedReader(this.saveFile, StandardCharsets.UTF_8);){
            String line = r.readLine();
            while ((line = r.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length < 3) continue;
                try {
                    UUID uuid = UUID.fromString(parts[0]);
                    int pr = Integer.parseInt(parts[1]);
                    long epoch = Long.parseLong(parts[2]);
                    records.add(new Record(uuid, pr, Instant.ofEpochSecond(epoch)));
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException ex) {
            this.logger.warn("Failed to load queue state: {}", (Object)ex.toString());
        }
        return records;
    }

    public void saveLeaderboard(Map<UUID, Long> totals) {
        try {
            Files.createDirectories(this.leaderboardFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(this.leaderboardFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                w.write("uuid,totalSeconds\n");
                for (Map.Entry<UUID, Long> e : totals.entrySet()) {
                    w.write(e.getKey() + "," + e.getValue() + "\n");
                }
            }
        }
        catch (IOException ex) {
            this.logger.warn("Failed to save leaderboard: {}", (Object)ex.toString());
        }
    }

    public Map<UUID, Long> loadLeaderboard() {
        HashMap<UUID, Long> map = new HashMap<UUID, Long>();
        if (Files.notExists(this.leaderboardFile, new LinkOption[0])) {
            return map;
        }
        try (BufferedReader r = Files.newBufferedReader(this.leaderboardFile, StandardCharsets.UTF_8);){
            String line = r.readLine();
            while ((line = r.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length < 2) continue;
                try {
                    UUID uuid = UUID.fromString(parts[0]);
                    long secs = Long.parseLong(parts[1]);
                    map.put(uuid, secs);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException ex) {
            this.logger.warn("Failed to load leaderboard: {}", (Object)ex.toString());
        }
        return map;
    }

    public record Record(UUID uuid, int priority, Instant joinedAt) {
    }
}

