/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;

public class AnalyticsService
implements AutoCloseable {
    private final Logger logger;
    private final ConfigManager config;
    private Connection conn;
    private String tableWaits;

    public AnalyticsService(Logger logger, ConfigManager config) {
        this.logger = logger;
        this.config = config;
    }

    public void init() {
        if (!this.config.dbEnabled()) {
            return;
        }
        String url = this.config.dbJdbcUrl();
        if (url == null || url.isBlank()) {
            this.logger.warn("DB enabled but jdbcUrl is blank");
            return;
        }
        try {
            this.conn = DriverManager.getConnection(url, this.config.dbUser(), this.config.dbPass());
            this.tableWaits = this.config.dbTablePrefix() + "waits";
            try (Statement st = this.conn.createStatement();){
                st.executeUpdate("CREATE TABLE IF NOT EXISTS " + this.tableWaits + " (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid VARCHAR(36) NOT NULL, priority INT NOT NULL, wait_seconds BIGINT NOT NULL, created_at BIGINT NOT NULL)");
            }
            this.logger.info("AnalyticsService initialized using {}", (Object)url);
        }
        catch (SQLException ex) {
            this.logger.warn("AnalyticsService init failed: {}", (Object)ex.toString());
            this.conn = null;
        }
    }

    public void recordWait(UUID uuid, int priority, long waitSeconds) {
        if (this.conn == null) {
            return;
        }
        String sql = "INSERT INTO " + this.tableWaits + " (uuid, priority, wait_seconds, created_at) VALUES (?,?,?,?)";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setInt(2, priority);
            ps.setLong(3, Math.max(0L, waitSeconds));
            ps.setLong(4, Instant.now().getEpochSecond());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.logger.debug("Analytics insert failed: {}", (Object)ex.toString());
        }
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn = null;
        }
    }
}

