/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.integrations.PterodactylAppClient;
import org.texboobcat.catQueue.services.CapacityService;

public class AutoscalerService {
    private final Logger logger;
    private final ConfigManager config;
    private final ProxyServer server;
    private final CapacityService capacityService;
    private final HttpClient http;
    private long lastScaleUpEpoch = 0L;
    private long lastScaleDownEpoch = 0L;
    private boolean bufferApplied = false;
    private long bufferUntilEpoch = 0L;
    private final PterodactylAppClient appClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, List<String>> dynamicServerIds = new ConcurrentHashMap<String, List<String>>();

    public AutoscalerService(Logger logger, ConfigManager config, ProxyServer server, CapacityService capacityService) {
        this.logger = logger;
        this.config = config;
        this.server = server;
        this.capacityService = capacityService;
        this.http = HttpClient.newHttpClient();
        this.appClient = config.pteroAppEnabled() ? new PterodactylAppClient(logger, config) : null;
    }

    public void tick() {
        if (!this.config.pteroEnabled()) {
            return;
        }
        try {
            boolean stopped;
            boolean started;
            boolean needScaleDown;
            int queueDepth = this.server.getAllPlayers().size() - this.totalCapacity();
            queueDepth = Math.max(0, queueDepth);
            String target = this.config.pteroUtilizationTargetServer();
            int cap = this.capacityService.getCapacity(target);
            int online = this.getOnline(target);
            int utilization = cap <= 0 ? 100 : (int)Math.round((double)online * 100.0 / (double)cap);
            boolean needScaleUp = queueDepth >= this.config.pteroQueueDepthThreshold() || utilization >= this.config.pteroUtilizationPercentThreshold();
            boolean bl = needScaleDown = queueDepth <= Math.max(0, this.config.pteroDownQueueDepthMax()) && utilization <= Math.max(0, this.config.pteroDownUtilizationPercentThreshold());
            if (needScaleUp && this.cooldownPassed(this.config.pteroCooldownUpSeconds()) && (started = this.startOneStoppedServerRespectingNodes())) {
                this.lastScaleUpEpoch = this.now();
                this.applyBootBuffer(target);
            }
            this.clearExpiredBuffer(target);
            if (needScaleDown && this.cooldownDownPassed(this.config.pteroCooldownDownSeconds()) && (stopped = this.stopOneRunningServerSafelyRespectingNodes())) {
                this.lastScaleDownEpoch = this.now();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Autoscaler tick error: {}", (Object)ex.toString());
        }
    }

    private int totalCapacity() {
        int sum = 0;
        for (RegisteredServer rs : this.server.getAllServers()) {
            sum += this.capacityService.getCapacity(rs.getServerInfo().getName());
        }
        return sum;
    }

    private int getOnline(String serverName) {
        Optional rs = this.server.getServer(serverName);
        return rs.map(s -> s.getPlayersConnected().size()).orElse(0);
    }

    private boolean cooldownPassed(int seconds) {
        return this.now() - this.lastScaleUpEpoch >= (long)Math.max(0, seconds);
    }

    private boolean cooldownDownPassed(int seconds) {
        return this.now() - this.lastScaleDownEpoch >= (long)Math.max(0, seconds);
    }

    private long now() {
        return Instant.now().getEpochSecond();
    }

    private boolean startOneStoppedServer() {
        List<String> ids = this.config.pteroServerIds();
        if (ids.isEmpty()) {
            return false;
        }
        for (String id : ids) {
            try {
                boolean ok;
                String state = this.getServerState(id);
                if (state == null) {
                    this.logger.debug("Pterodactyl: could not read state for {}", (Object)id);
                    continue;
                }
                if (state.equalsIgnoreCase("running") || state.equalsIgnoreCase("starting") || !(ok = this.sendPowerSignal(id, "start"))) continue;
                this.logger.info("Pterodactyl: start signal sent to server {} (state was: {})", (Object)id, (Object)state);
                return true;
            }
            catch (Exception ex) {
                this.logger.warn("Pterodactyl start error for {}: {}", (Object)id, (Object)ex.toString());
            }
        }
        return false;
    }

    private boolean startOneStoppedServerRespectingNodes() {
        List<ConfigManager.NodeDef> nodes = this.config.pteroNodes();
        if (nodes != null && !nodes.isEmpty()) {
            for (ConfigManager.NodeDef node : nodes) {
                try {
                    int running = this.countRunning(this.getNodeAllServerIds(node.name, node.serverIds));
                    if (node.maxLobbies > 0 && running >= node.maxLobbies) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    this.logger.debug("Autoscaler: node running count failed for {}: {}", (Object)node.name, (Object)ex.toString());
                }
                boolean startedAny = false;
                for (String id : node.serverIds) {
                    try {
                        boolean ok;
                        String state = this.getServerState(id);
                        if (state == null || state.equalsIgnoreCase("running") || state.equalsIgnoreCase("starting") || !(ok = this.sendPowerSignal(id, "start"))) continue;
                        this.logger.info("Pterodactyl: start signal sent to server {} on node {}", (Object)id, (Object)node.name);
                        startedAny = true;
                        break;
                    }
                    catch (Exception ex) {
                        this.logger.warn("Pterodactyl start error for {}: {}", (Object)id, (Object)ex.toString());
                    }
                }
                if (startedAny) {
                    return true;
                }
                if (this.appClient == null || node.nodeId <= 0) continue;
                try {
                    String name = "lobby-auto-" + this.now();
                    String newId = this.appClient.createLobbyServer(node.nodeId, name);
                    if (newId == null || newId.isEmpty()) continue;
                    this.dynamicServerIds.computeIfAbsent(node.name, k -> new ArrayList()).add(newId);
                    this.logger.info("Pterodactyl: created new lobby {} on node {} (id={})", new Object[]{name, node.name, newId});
                    return true;
                }
                catch (Exception ex) {
                    this.logger.warn("Pterodactyl: failed to create lobby on node {}: {}", (Object)node.name, (Object)ex.toString());
                }
            }
            return false;
        }
        return this.startOneStoppedServer();
    }

    private boolean stopOneRunningServerSafely() {
        List<String> ids = this.config.pteroServerIds();
        if (ids.isEmpty()) {
            return false;
        }
        try {
            int running = this.countRunning(ids);
            if (running <= 1) {
                this.logger.debug("Autoscaler: not stopping; only {} running extra servers", (Object)running);
                return false;
            }
        }
        catch (Exception ex) {
            this.logger.debug("Autoscaler: count running failed: {}", (Object)ex.toString());
        }
        for (String id : ids) {
            try {
                boolean ok;
                String state = this.getServerState(id);
                if (state == null || !state.equalsIgnoreCase("running") || !(ok = this.sendPowerSignal(id, "stop"))) continue;
                this.logger.info("Pterodactyl: stop signal sent to server {}", (Object)id);
                return true;
            }
            catch (Exception ex) {
                this.logger.warn("Pterodactyl stop error for {}: {}", (Object)id, (Object)ex.toString());
            }
        }
        return false;
    }

    private boolean stopOneRunningServerSafelyRespectingNodes() {
        List<ConfigManager.NodeDef> nodes = this.config.pteroNodes();
        if (nodes != null && !nodes.isEmpty()) {
            for (ConfigManager.NodeDef node : nodes) {
                try {
                    List<String> allIds = this.getNodeAllServerIds(node.name, node.serverIds);
                    int running = this.countRunning(allIds);
                    if (node.maxLobbies <= 0 || running <= node.maxLobbies) continue;
                    for (String id : allIds) {
                        try {
                            boolean ok;
                            String state = this.getServerState(id);
                            if (state == null || !state.equalsIgnoreCase("running") || !(ok = this.sendPowerSignal(id, "stop"))) continue;
                            this.logger.info("Pterodactyl: stop signal sent to server {} on node {}", (Object)id, (Object)node.name);
                            return true;
                        }
                        catch (Exception ex) {
                            this.logger.warn("Pterodactyl stop error for {}: {}", (Object)id, (Object)ex.toString());
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.debug("Autoscaler: node running count failed for {}: {}", (Object)node.name, (Object)ex.toString());
                }
            }
            return this.stopOneRunningServerSafely();
        }
        return this.stopOneRunningServerSafely();
    }

    private List<String> getNodeAllServerIds(String nodeName, List<String> configured) {
        ArrayList<String> all = new ArrayList<String>();
        if (configured != null) {
            all.addAll(configured);
        }
        List dyn = this.dynamicServerIds.getOrDefault(nodeName, List.of());
        all.addAll(dyn);
        return all;
    }

    private String getServerState(String id) throws IOException, InterruptedException {
        if (this.config.pteroDryRun()) {
            return "stopped";
        }
        String url = this.trimSlash(this.config.pteroBaseUrl()) + "/api/client/servers/" + id;
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).header("Authorization", "Bearer " + this.config.pteroApiKey()).header("Accept", "application/json").GET().build();
        HttpResponse<String> resp = this.http.send(req, HttpResponse.BodyHandlers.ofString());
        if (resp.statusCode() / 100 != 2) {
            this.logger.debug("Pterodactyl GET state non-2xx: {} body={}", (Object)resp.statusCode(), (Object)resp.body());
            return null;
        }
        try {
            JsonNode root = this.objectMapper.readTree(resp.body());
            String s = this.findStringField(root, "current_state");
            return s;
        }
        catch (Exception ex) {
            this.logger.debug("Pterodactyl GET state parse error: {}", (Object)ex.toString());
            return null;
        }
    }

    private boolean sendPowerSignal(String id, String signal) throws IOException, InterruptedException {
        if (this.config.pteroDryRun()) {
            this.logger.info("[DryRun] Would send power '{}' to Pterodactyl server {}", (Object)signal, (Object)id);
            return true;
        }
        String url = this.trimSlash(this.config.pteroBaseUrl()) + "/api/client/servers/" + id + "/power";
        String json = "{\"signal\":\"" + signal + "\"}";
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).header("Authorization", "Bearer " + this.config.pteroApiKey()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        HttpResponse<String> resp = this.http.send(req, HttpResponse.BodyHandlers.ofString());
        if (resp.statusCode() / 100 == 2) {
            return true;
        }
        this.logger.debug("Pterodactyl power non-2xx: {} body={}", (Object)resp.statusCode(), (Object)resp.body());
        return false;
    }

    private String trimSlash(String base) {
        if (base == null) {
            return "";
        }
        if (base.endsWith("/")) {
            return base.substring(0, base.length() - 1);
        }
        return base;
    }

    private void applyBootBuffer(String targetServerName) {
        if (this.bufferApplied) {
            return;
        }
        int slots = Math.max(0, this.config.pteroBootBufferSlots());
        if (slots <= 0) {
            return;
        }
        int current = this.capacityService.getCapacity(targetServerName);
        this.capacityService.setOverride(targetServerName, current + slots);
        this.bufferApplied = true;
        this.bufferUntilEpoch = this.now() + (long)Math.max(1, this.config.pteroBootBufferSeconds());
        this.logger.info("Autoscaler: applied boot buffer +{} slots to {} for {}s", new Object[]{slots, targetServerName, this.config.pteroBootBufferSeconds()});
    }

    private void clearExpiredBuffer(String targetServerName) {
        if (!this.bufferApplied) {
            return;
        }
        if (this.now() >= this.bufferUntilEpoch) {
            this.capacityService.clearOverride(targetServerName);
            this.bufferApplied = false;
            this.logger.info("Autoscaler: cleared boot buffer for {}", (Object)targetServerName);
        }
    }

    private int countRunning(List<String> ids) throws IOException, InterruptedException {
        int c = 0;
        for (String id : ids) {
            String s = this.getServerState(id);
            if (s == null || !s.equalsIgnoreCase("running")) continue;
            ++c;
        }
        return c;
    }

    private String findStringField(JsonNode node, String field) {
        String v;
        JsonNode d;
        JsonNode a;
        if (node == null) {
            return null;
        }
        if (node.has(field) && node.get(field).isTextual()) {
            return node.get(field).asText();
        }
        if (node.has("attributes") && (a = node.get("attributes")) != null && a.has(field) && a.get(field).isTextual()) {
            return a.get(field).asText();
        }
        if (node.has("data") && (d = node.get("data")) != null && (v = this.findStringField(d, field)) != null) {
            return v;
        }
        Iterator<JsonNode> it = node.elements();
        while (it.hasNext()) {
            v = this.findStringField(it.next(), field);
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

