/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.catQueue.config.ConfigManager;

public class CapacityService {
    private final ConfigManager config;
    private final ProxyServer server;
    private final Map<String, Integer> overrides = new ConcurrentHashMap<String, Integer>();

    public CapacityService(ConfigManager config, ProxyServer server) {
        this.config = config;
        this.server = server;
    }

    public int getCapacity(String serverName) {
        int base = this.overrides.getOrDefault(serverName.toLowerCase(), this.config.serverCapacity(serverName));
        if (!this.config.autoscaleEnabled()) {
            return base;
        }
        int online = "target".equalsIgnoreCase(this.config.autoscaleMode()) ? this.server.getServer(serverName).map(rs -> rs.getPlayersConnected().size()).orElse(0).intValue() : this.server.getAllPlayers().size();
        int per = Math.max(1, this.config.autoscalePlayersPerExtraSlot());
        int extra = Math.min(this.config.autoscaleMaxExtra(), online / per);
        return Math.max(0, base + extra);
    }

    public void setOverride(String serverName, int capacity) {
        this.overrides.put(serverName.toLowerCase(), Math.max(0, capacity));
    }

    public void clearOverride(String serverName) {
        this.overrides.remove(serverName.toLowerCase());
    }
}

