/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class LeaderboardService {
    private final Logger logger;
    private final Map<UUID, Long> totalWaitSeconds = new ConcurrentHashMap<UUID, Long>();

    public LeaderboardService(Logger logger) {
        this.logger = logger;
    }

    public void recordWait(UUID uuid, Duration wait) {
        this.totalWaitSeconds.merge(uuid, wait.getSeconds(), Long::sum);
        this.logger.debug("Leaderboard: {} += {}s (total {}s)", new Object[]{uuid, wait.getSeconds(), this.totalWaitSeconds.get(uuid)});
    }

    public Map<UUID, Long> snapshot() {
        return Map.copyOf(this.totalWaitSeconds);
    }

    public void replaceAll(Map<UUID, Long> data) {
        this.totalWaitSeconds.clear();
        this.totalWaitSeconds.putAll(data);
    }

    public List<Map.Entry<UUID, Long>> getTop(int n) {
        ArrayList<Map.Entry<UUID, Long>> list = new ArrayList<Map.Entry<UUID, Long>>(this.totalWaitSeconds.entrySet());
        list.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        if (n < list.size()) {
            return list.subList(0, n);
        }
        return list;
    }
}

