/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.music.InstrumentMap;
import org.texboobcat.catQueue.music.NbsParser;
import org.texboobcat.catQueue.music.NbsSong;

public class MusicService {
    private final Logger logger;
    private final ProxyServer server;
    private final ConfigManager config;
    private final QueueManager queueManager;
    private final Set<UUID> muted = ConcurrentHashMap.newKeySet();
    private int idx = 0;
    private NbsSong currentSong = null;
    private int songTick = 0;
    private int tickAccumulator = 0;
    private final Path dataDirectory;

    public MusicService(Logger logger, ProxyServer server, ConfigManager config, QueueManager queueManager, Path dataDirectory) {
        this.logger = logger;
        this.server = server;
        this.config = config;
        this.queueManager = queueManager;
        this.dataDirectory = dataDirectory;
        this.tryLoadDefaultSong();
    }

    public boolean toggleMute(UUID uuid) {
        if (this.muted.contains(uuid)) {
            this.muted.remove(uuid);
            return false;
        }
        this.muted.add(uuid);
        return true;
    }

    public boolean isMuted(UUID uuid) {
        return this.muted.contains(uuid);
    }

    public void playTick() {
        int targetIntervalTicks = 1;
        boolean useFileTempo = "file".equalsIgnoreCase(this.config.musicTempoMode());
        if (this.currentSong != null && useFileTempo) {
            float tps = Math.max(1.0f, this.currentSong.tempoTps());
            targetIntervalTicks = Math.max(1, Math.round(20.0f / tps));
        } else {
            targetIntervalTicks = Math.max(1, this.config.musicTempoTicks());
        }
        ++this.tickAccumulator;
        if (this.tickAccumulator < targetIntervalTicks) {
            return;
        }
        this.tickAccumulator = 0;
        if (this.currentSong != null) {
            float baseVolume = Math.max(0.0f, Math.min(1.0f, this.config.musicVolume()));
            List<NbsSong.NoteEvent> events = this.currentSong.eventsAt(this.songTick);
            for (NbsSong.NoteEvent ev : events) {
                float pitch = this.keyToPitch(ev.key);
                Key key = InstrumentMap.toSoundKey(ev.instrument);
                int layerVol = this.currentSong.layerVolume(ev.layer);
                float vol = baseVolume * ((float)ev.velocity / 100.0f) * ((float)layerVol / 100.0f);
                Sound sound = Sound.sound((Key)key, (Sound.Source)Sound.Source.RECORD, (float)vol, (float)(pitch *= (float)Math.pow(2.0, (double)ev.fineCents / 1200.0)));
                for (UUID uuid : this.queueManager.listQueued()) {
                    if (this.muted.contains(uuid)) continue;
                    this.server.getPlayer(uuid).ifPresent(p -> this.safePlay((Player)p, sound));
                }
            }
            ++this.songTick;
            if (this.songTick >= this.currentSong.lengthTicks()) {
                this.songTick = 0;
            }
            return;
        }
        List<Integer> notes = this.config.musicNotes();
        if (notes == null || notes.isEmpty()) {
            return;
        }
        int note = notes.get(this.idx % notes.size());
        ++this.idx;
        float volume = Math.max(0.0f, Math.min(1.0f, this.config.musicVolume()));
        float pitch = this.noteToPitch(note);
        Sound sound = Sound.sound((Key)InstrumentMap.toSoundKey(0), (Sound.Source)Sound.Source.RECORD, (float)volume, (float)pitch);
        for (UUID uuid : this.queueManager.listQueued()) {
            if (this.muted.contains(uuid)) continue;
            this.server.getPlayer(uuid).ifPresent(p -> this.safePlay((Player)p, sound));
        }
    }

    public boolean loadSongByName(String name) {
        File folder = this.getSongsFolder();
        File target = new File(folder, name);
        if (!target.exists()) {
            return false;
        }
        try {
            NbsSong song;
            NbsParser parser = new NbsParser(this.logger);
            this.currentSong = song = parser.parse(target);
            this.songTick = 0;
            this.idx = 0;
            return true;
        }
        catch (Exception ex) {
            this.logger.warn("Failed to load NBS song {}: {}", (Object)name, (Object)ex.toString());
            return false;
        }
    }

    public void stopSong() {
        this.currentSong = null;
        this.songTick = 0;
    }

    public List<String> listSongs() {
        File folder = this.getSongsFolder();
        Object[] files = folder.list((dir, name) -> name.toLowerCase().endsWith(".nbs"));
        if (files == null) {
            return List.of();
        }
        Arrays.sort(files);
        return List.of(files);
    }

    private void tryLoadDefaultSong() {
        try {
            boolean ok;
            String def = this.config.node("music", "defaultSong").getString("");
            if (def != null && !def.isBlank() && !(ok = this.loadSongByName(def))) {
                this.logger.info("Default NBS song '{}' not found; using simple melody fallback.", (Object)def);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private File getSongsFolder() {
        Path folderPath = this.dataDirectory.resolve(this.config.musicFolder());
        File folder = folderPath.toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    private void safePlay(Player player, Sound sound) {
        try {
            player.playSound(sound);
        }
        catch (Throwable t) {
            this.logger.debug("Failed to play sound for {}: {}", (Object)player.getUsername(), (Object)t.toString());
        }
    }

    private float noteToPitch(int semitone) {
        return (float)Math.pow(2.0, (double)semitone / 12.0);
    }

    private float keyToPitch(int key) {
        return (float)Math.pow(2.0, (double)(key - 45) / 12.0);
    }
}

