/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;

public class RewardService {
    private final Logger logger;
    private final ProxyServer server;
    private final ConfigManager config;

    public RewardService(Logger logger, ProxyServer server, ConfigManager config) {
        this.logger = logger;
        this.server = server;
        this.config = config;
    }

    public void grantWaitReward(UUID uuid, Duration wait) {
        long secs = Math.max(0L, wait.getSeconds());
        if (!this.config.rewardsEnabled()) {
            this.logger.debug("RewardService disabled; {} waited {}s", (Object)uuid, (Object)secs);
            return;
        }
        String playerName = this.server.getPlayer(uuid).map(p -> p.getUsername()).orElse(uuid.toString());
        for (String cmd : this.config.rewardCommands()) {
            String run = cmd.replace("%player%", playerName).replace("%wait_seconds%", Long.toString(secs));
            this.server.getCommandManager().executeAsync((CommandSource)this.server.getConsoleCommandSource(), run);
            this.logger.info("RewardService executed: {}", (Object)run);
        }
    }
}

