/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.catQueue.services;

import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import org.texboobcat.catQueue.config.ConfigManager;
import org.texboobcat.catQueue.core.QueueManager;
import org.texboobcat.catQueue.integrations.DiscordNotifier;
import org.texboobcat.catQueue.util.MessageUtil;

public class TimeoutService {
    private final QueueManager queueManager;
    private final ConfigManager config;
    private final ProxyServer server;
    private final Logger logger;
    private final DiscordNotifier discordNotifier;

    public TimeoutService(QueueManager queueManager, ConfigManager config, ProxyServer server, Logger logger, DiscordNotifier discordNotifier) {
        this.queueManager = queueManager;
        this.config = config;
        this.server = server;
        this.logger = logger;
        this.discordNotifier = discordNotifier;
    }

    public void tick() {
        if (!this.config.featureTimeouts()) {
            return;
        }
        int warnSec = this.config.timeoutWarnSeconds();
        int kickSec = this.config.timeoutKickSeconds();
        Instant now = Instant.now();
        for (UUID uuid : this.queueManager.listQueued()) {
            Optional<QueueManager.QueueEntry> opt = this.queueManager.getEntry(uuid);
            if (opt.isEmpty()) continue;
            QueueManager.QueueEntry entry = opt.get();
            long waited = Duration.between(entry.joinedAt, now).getSeconds();
            if (waited >= (long)kickSec) {
                this.queueManager.remove(uuid);
                this.server.getPlayer(uuid).ifPresent(p -> p.disconnect((Component)Component.text((String)this.config.msgRemoved())));
                if (this.config.featureDiscord() && this.discordNotifier != null) {
                    String name = this.server.getPlayer(uuid).map(pl -> pl.getUsername()).orElse(uuid.toString());
                    this.discordNotifier.send("Queue timeout: " + name + " removed after " + waited + "s");
                }
                this.logger.debug("Kicked {} from queue for timeout.", (Object)uuid);
                continue;
            }
            if (waited < (long)warnSec) continue;
            this.server.getPlayer(uuid).ifPresent(p -> {
                HashMap<String, String> ph = new HashMap<String, String>();
                ph.put("position", String.valueOf(this.queueManager.getPosition(uuid)));
                ph.put("eta", MessageUtil.humanize(this.queueManager.estimateWait(uuid, this.config.slotsPerMinute(), this.config.pteroUtilizationTargetServer())));
                p.sendMessage((Component)Component.text((String)MessageUtil.apply(this.config.msgWarnTimeout(), ph)));
            });
        }
    }
}

